"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFormatterUTF8 = void 0;
var separatorTypes = {
    ascii: ' -|+--++|+|+++++',
    rounded: ' ╴╷╮╶─╭┬╵╯│┤╰┴├┼',
    utf8: ' ╴╷┐╶─┌┬╵┘│┤└┴├┼'
};
var ANSI_RESET = '\u001b[0m';
var ansiColors = {
    black: '\u001b[30m',
    blue: '\u001b[34m',
    cyan: '\u001b[36m',
    default: '',
    green: '\u001b[32m',
    magenta: '\u001b[35m',
    red: '\u001b[31m',
    white: '\u001b[37m',
    yellow: '\u001b[33m'
};
function outputFormatterUTF8(renderData, options) {
    var _a;
    var ansi = !!(options === null || options === void 0 ? void 0 : options.ansi);
    var flavor = (options === null || options === void 0 ? void 0 : options.flavor) || 'utf8';
    var separators = separatorTypes[flavor] || separatorTypes.utf8;
    var separatorSpaces = (Math.floor((options === null || options === void 0 ? void 0 : options.separatorSpaces) || 1) > 1 ? Math.floor((options === null || options === void 0 ? void 0 : options.separatorSpaces) || 1) : 3);
    var borders = renderData.borders, cellConfig = renderData.cellConfig, columns = renderData.columns, rows = renderData.rows, startX = renderData.startX, startY = renderData.startY;
    var out = '';
    for (var y = startY; y < rows; y++) {
        var len = ((_a = borders.grid[startX]) === null || _a === void 0 ? void 0 : _a[y].length) || 0;
        for (var i = 0; i < len; i++) {
            for (var x = startX; x < columns; x++) {
                var _b = cellConfig[x][y], bold = _b.bold, color = _b.color;
                var gridRow = borders.grid[x][y][i];
                var gridRowLen = gridRow.length;
                for (var ii = 0; ii < gridRowLen; ii++) {
                    var part = gridRow[ii];
                    if (Array.isArray(part)) {
                        out += (ansi ? '\u001b[38;5;240m' : '') +
                            separators[part[0]].repeat(ii === 1 && part[1] === 1 && gridRow[0] === '' ? separatorSpaces : part[1]) +
                            (ansi ? ANSI_RESET : '');
                    }
                    else if (ansi && part.trim()) {
                        var colorCode = color && color !== 'default' && ansiColors[color] || '';
                        out += "".concat(bold ? '\u001b[1m' : '').concat(colorCode).concat(part).concat(bold || colorCode ? ANSI_RESET : '');
                    }
                    else {
                        out += part;
                    }
                }
            }
        }
    }
    return out;
}
exports.outputFormatterUTF8 = outputFormatterUTF8;
