"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableRenderBorderData = void 0;
/**
 * Border data
 */
var TableRenderBorderData = /** @class */ (function () {
    /**
     * Instantiate border info object, set minimum data
     * @param renderData data source
     */
    function TableRenderBorderData(renderData) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        /**
         * border grid and content logical description (sep = TLBRSeparator, i.e [TRBL, multiplier])
         * edge  pad  content  pad  edge  eol
         * [sep, sep,   sep,   sep, sep, enter]
         * [sep, sep, line[i], sep, sep, enter] x lines.length
         * [sep, sep,   sep,   sep, sep, enter]
         **/
        this.grid = [];
        /** Map of horizontal (top/bottom) borders on (x, y) coordinates (+ 1 closing row) */
        this.horizontal = [];
        /** Indication of at least 1 horizontal border for each y coordinate (+ 1 closing row) */
        this.horizontalSerparation = [];
        /** Map of vertical (left/right) borders on (x, y) coordinates (+ 1 closing column) */
        this.vertical = [];
        /** Indication of at least 1 vertical border for each x coordinate (+ 1 closing column) */
        this.verticalSerparation = [];
        var cellConfig = renderData.cellConfig, cellValueRenderedMultiline = renderData.cellValueRenderedMultiline, columnWidth = renderData.columnWidth, columns = renderData.columns, rows = renderData.rows, startX = renderData.startX, startY = renderData.startY;
        for (var x = startX; x < columns; x++) {
            this.horizontal[x] = [];
            this.vertical[x] = [];
            this.grid[x] = [];
        }
        this.horizontal[columns] = [];
        this.vertical[columns] = [];
        for (var x = startX; x <= columns; x++) {
            for (var y = startY; y <= rows; y++) {
                this.horizontal[x][y] = ((_b = (_a = cellConfig[x]) === null || _a === void 0 ? void 0 : _a[y - 1]) === null || _b === void 0 ? void 0 : _b.borderBottom) || ((_d = (_c = cellConfig[x]) === null || _c === void 0 ? void 0 : _c[y]) === null || _d === void 0 ? void 0 : _d.borderTop) || false;
                this.horizontalSerparation[y] = this.horizontalSerparation[y] || this.horizontal[x][y];
                this.vertical[x][y] = ((_f = (_e = cellConfig[x - 1]) === null || _e === void 0 ? void 0 : _e[y]) === null || _f === void 0 ? void 0 : _f.borderRight) || ((_h = (_g = cellConfig[x]) === null || _g === void 0 ? void 0 : _g[y]) === null || _h === void 0 ? void 0 : _h.borderLeft) || false;
                this.verticalSerparation[x] = this.verticalSerparation[x] || this.vertical[x][y];
            }
        }
        // build the grid
        for (var x = startX; x < columns; x++) {
            var hasLeftPadding = this.verticalSerparation[x] || x > startX;
            var hasRightPadding = this.verticalSerparation[x + 1];
            var lineEnd = (x === columns - 1 ? '\n' : '');
            for (var y = startY; y < rows; y++) {
                var lines = cellValueRenderedMultiline[x][y];
                var grid = (this.grid[x][y] = []);
                var hasTopBorder = this.horizontal[x][y];
                var hasBottomBorder = this.horizontal[x][y + 1];
                var hasLeftBorder = this.vertical[x][y];
                var hasRightBorder = (_j = this.vertical[x + 1]) === null || _j === void 0 ? void 0 : _j[y];
                if (this.horizontalSerparation[y]) {
                    grid.push([
                        (this.verticalSerparation[x] ? [this.crossingID(x, y), 1] : ''),
                        (hasLeftPadding ? [(hasTopBorder ? 5 : 0), 1] : ''),
                        [(hasTopBorder ? 5 : 0), columnWidth[x]],
                        (hasRightPadding ? [(hasTopBorder ? 5 : 0), 1] : ''),
                        (lineEnd && this.verticalSerparation[x + 1] ? [this.crossingID(x + 1, y), 1] : ''),
                        lineEnd
                    ]);
                }
                var len = lines.length;
                for (var i = 0; i < len; i++) {
                    grid.push([
                        (this.verticalSerparation[x] ? [(hasLeftBorder ? 10 : 0), 1] : ''),
                        (hasLeftPadding ? [0, 1] : ''),
                        lines[i],
                        (hasRightPadding ? [0, 1] : ''),
                        (lineEnd && this.verticalSerparation[x + 1] ? [(hasRightBorder ? 10 : 0), 1] : ''),
                        lineEnd
                    ]);
                }
                if (y === rows - 1 && this.horizontalSerparation[y + 1]) {
                    grid.push([
                        (this.verticalSerparation[x] ? [this.crossingID(x, y + 1), 1] : ''),
                        (hasLeftPadding ? [(hasBottomBorder ? 5 : 0), 1] : ''),
                        [(hasBottomBorder ? 5 : 0), columnWidth[x]],
                        (hasRightPadding ? [(hasBottomBorder ? 5 : 0), 1] : ''),
                        (lineEnd && this.verticalSerparation[x + 1] ? [this.crossingID(x + 1, y + 1), 1] : ''),
                        lineEnd
                    ]);
                }
            }
        }
    }
    /**
     * Get the Top|Left|Bottom|Right bitmask value for crossing
     * @param x coordinate
     * @param y coordinate
     * @returns TRBL position
     */
    TableRenderBorderData.prototype.crossingID = function (x, y) {
        var vertical = this.vertical[x];
        var horizontal = this.horizontal[x];
        var horizontalPre = this.horizontal[x - 1];
        return (vertical && vertical[y - 1] ? 8 : 0) +
            (horizontal && horizontal[y] && x < this.horizontal.length - 1 ? 4 : 0) +
            (vertical && vertical[y] && y < vertical.length - 1 ? 2 : 0) +
            (horizontalPre && horizontalPre[y] ? 1 : 0);
    };
    return TableRenderBorderData;
}());
exports.TableRenderBorderData = TableRenderBorderData;
