"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function postfixAssertion(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("postfixAssertion");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { attributePath, postfixAssertionOperator } = yard.post("postfixAssertion");
            if (attributePath.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 attributePath, but got ${attributePath.length};`);
            }
            if (postfixAssertionOperator.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 postfixAssertionOperator, but got ${postfixAssertionOperator.length};`);
            }
            yard.tracks.postfixAssertion.push((data) => {
                return postfixAssertionOperator[0](attributePath[0], data);
            });
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.postfixAssertion = postfixAssertion;
//# sourceMappingURL=postfixAssertion.js.map