"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
const util_1 = require("./util");
// TODO: implement unicode string comparisons using
// String.prototype.localeCompare()
function pr(path, data) {
    return util_1.traverse(path, data).some(x => x !== undefined);
}
const map = {
    pr
};
function postfixAssertionOperator(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            break;
        case apg_lib_1.ids.SEM_POST:
            const op = apg_lib_1.utils
                .charsToString(chars, phraseIndex, phraseLength)
                .toLowerCase();
            const fn = map[op];
            if (!fn) {
                throw new Error(`INVARIANT: No such postfix assertion operator \`${op}\`.`);
            }
            yard.tracks.postfixAssertionOperator.push(fn);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.postfixAssertionOperator = postfixAssertionOperator;
//# sourceMappingURL=postfixAssertionOperator.js.map