"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function precedenceGroup(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("precedenceGroup");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { filter } = yard.post("precedenceGroup");
            if (filter.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 filter, but got ${filter.length};`);
            }
            yard.tracks.precedenceGroup.push(filter[0]);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.precedenceGroup = precedenceGroup;
//# sourceMappingURL=precedenceGroup.js.map