"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeInterface = void 0;
const graphql_1 = require("graphql");
const fields_js_1 = require("./fields.js");
const directives_js_1 = require("./directives.js");
const index_js_1 = require("./index.js");
function mergeInterface(node, existingNode, config) {
    if (existingNode) {
        try {
            return {
                name: node.name,
                description: node['description'] || existingNode['description'],
                kind: (config === null || config === void 0 ? void 0 : config.convertExtensions) ||
                    node.kind === 'InterfaceTypeDefinition' ||
                    existingNode.kind === 'InterfaceTypeDefinition'
                    ? 'InterfaceTypeDefinition'
                    : 'InterfaceTypeExtension',
                loc: node.loc,
                fields: (0, fields_js_1.mergeFields)(node, node.fields, existingNode.fields, config),
                directives: (0, directives_js_1.mergeDirectives)(node.directives, existingNode.directives, config),
                interfaces: node['interfaces']
                    ? (0, index_js_1.mergeNamedTypeArray)(node['interfaces'], existingNode['interfaces'], config)
                    : undefined,
            };
        }
        catch (e) {
            throw new Error(`Unable to merge GraphQL interface "${node.name.value}": ${e.message}`);
        }
    }
    return (config === null || config === void 0 ? void 0 : config.convertExtensions)
        ? {
            ...node,
            kind: graphql_1.Kind.INTERFACE_TYPE_DEFINITION,
        }
        : node;
}
exports.mergeInterface = mergeInterface;
