"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_group_1 = require("../search-resource-group");
const indexer_1 = require("./indexer");
__export(require("./indexer"));
/**
 * Manage Azure Search indexer resources
 */
class Indexers extends search_resource_group_1.SearchResourceGroup {
    /**
     * Manage Azure Search indexer resources
     * @param requester http handler
     */
    constructor(requester) {
        super(requester, 'indexers');
    }
    /**
     * Use a named indexer
     * @param indexerName name of the indexer
     */
    use(indexerName) {
        return new indexer_1.Indexer(this.requester, this.type, indexerName);
    }
}
exports.Indexers = Indexers;
//# sourceMappingURL=index.js.map