/// <reference types="node" />
import { EventEmitter } from 'events';
import { AzureSearchResponse, OptionsOrCallback, SearchCallback, SearchRequest } from './types';
/** Internal class to handle search HTTP requests/responses */
export declare class SearchRequester {
    service: string;
    defaultVersion: string;
    events: EventEmitter;
    private adminKeys;
    private readonly endpoint;
    constructor(service: string, adminKey: string | string[], defaultVersion: string);
    request<T>(req: SearchRequest<T>, optionsOrCallback?: OptionsOrCallback<T>, callback?: SearchCallback<T>): Promise<AzureSearchResponse<T>>;
    private getParams;
}
