import { SearchRequester } from './search-requester';
import { AzureSearchResponse, ListOptions, ListResults, SearchCallback, SearchOptions } from './types';
/**
 * Base class for search resource groups
 */
export declare abstract class SearchResourceGroup<TSchema> {
    protected requester: SearchRequester;
    protected type: string;
    /**
     * Create new instance of the search resource group
     * @param requester http handler
     * @param type the type of resource (should match /{resource}/ in the REST url path)
     * @param resource resource handler class
     */
    constructor(requester: SearchRequester, type: string);
    /**
     * Create a new resource
     * @param schema resource definition
     * @param options optional request options
     */
    create(schema: TSchema, options?: SearchOptions): Promise<AzureSearchResponse<void>>;
    create(schema: TSchema, callback: SearchCallback<void>): void;
    create(schema: TSchema, options: SearchOptions, callback: SearchCallback<void>): void;
    /**
     * List all resources
     * @param options optional request options
     */
    list(options?: SearchOptions & ListOptions): Promise<AzureSearchResponse<ListResults<TSchema>>>;
    list(callback: SearchCallback<ListResults<TSchema>>): void;
    list(options: SearchOptions & ListOptions, callback: SearchCallback<ListResults<TSchema>>): void;
    private request;
}
