"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_group_1 = require("../search-resource-group");
const skill_set_1 = require("./skill-set");
/** Manage Azure Search skill sets */
class SkillSets extends search_resource_group_1.SearchResourceGroup {
    constructor(requester) {
        super(requester, 'skillsets');
    }
    /**
     * Use a named skill set
     * @param skillSetName name of the skill set
     */
    use(skillSetName) {
        return new skill_set_1.SkillSet(this.requester, this.type, skillSetName);
    }
}
exports.SkillSets = SkillSets;
//# sourceMappingURL=index.js.map