'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = {
  name: 'header',

  lookup: function lookup(req, res, options) {
    var found = void 0;

    if (typeof req !== 'undefined') {
      var headers = req.headers;
      if (!headers) return found;

      var locales = [];
      var acceptLanguage = options.lookupHeader ? headers[options.lookupHeader] : headers['accept-language'];

      if (acceptLanguage) {
        var lngs = [],
            i = void 0,
            m = void 0;
        var rgx = /(([a-z]{2})-?([A-Z]{2})?)\s*;?\s*(q=([0-9.]+))?/gi;

        do {
          m = rgx.exec(acceptLanguage);
          if (m) {
            var lng = m[1],
                weight = m[5] || '1',
                q = Number(weight);
            if (lng && !isNaN(q)) {
              lngs.push({ lng: lng, q: q });
            }
          }
        } while (m);

        lngs.sort(function (a, b) {
          return b.q - a.q;
        });

        for (i = 0; i < lngs.length; i++) {
          locales.push(lngs[i].lng);
        }

        if (locales.length) found = locales;
      }
    }

    return found;
  }
};