"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configMulticoord = void 0;
var container_2d_class_1 = require("../container-2d.class");
function configMulticoord(input) {
    var _a;
    var list = [];
    if (typeof input === 'string') {
        var parts = input.replace(/\s/g, '').split(',');
        for (var _i = 0, parts_1 = parts; _i < parts_1.length; _i++) {
            var part = parts_1[_i];
            var matched = part.match(/^(-1|[0-9]+)(..(-1|[0-9]+))*$/);
            if (!matched || !(+matched[1] >= -1) || (matched[3] && !(+matched[3] >= -1))) {
                throw new Error("Invalid coordinate spec: \"".concat(part, "\" in \"").concat(input, "\""));
            }
            var from = +matched[1];
            var til = +matched[matched[3] != null ? 3 : 1];
            if (from > til) {
                _a = [til, from], from = _a[0], til = _a[1];
            }
            for (var i = from; i <= til; i++) {
                list.push(i);
            }
        }
    }
    else {
        container_2d_class_1.Container2D.checkCoordinate(input);
        list.push(input);
    }
    return list;
}
exports.configMulticoord = configMulticoord;
