import { ConfigValue } from './config-value.type';
import { Configs } from './configs.class';
import { IncomingConfigValue } from './incoming-config-value.type';
import { RenderConfig } from './render-config.type';
export declare const CONFIG_ALIGN: readonly ["center", "left", "right"];
declare const CONFIG_BORDERS: readonly ["borderBottom", "borderLeft", "borderRight", "borderTop"];
declare const CONFIG_COLORS: readonly ["black", "blue", "cyan", "default", "green", "magenta", "red", "white", "yellow"];
export declare const CONFIG_VALIGN: readonly ["bottom", "middle", "top"];
export declare type Align = (typeof CONFIG_ALIGN)[number];
export declare type BorderProperty = (typeof CONFIG_BORDERS)[number];
export declare type Color = (typeof CONFIG_COLORS)[number];
export declare type VAlign = (typeof CONFIG_VALIGN)[number];
export declare class Config {
    protected readonly parent: Configs;
    x: number;
    y: number;
    protected _value: ConfigValue;
    static sanitizeAlign(input: Align, fallback?: Align): Align;
    static sanitizeVAlign(input: VAlign, fallback?: VAlign): VAlign;
    constructor(parent: Configs, x: number, y: number, _value: ConfigValue);
    get renderConfig(): RenderConfig;
    /** read and add defaults */
    get value(): ConfigValue;
    /** sanitze and update */
    set value(config: IncomingConfigValue);
    borderValue(prop: BorderProperty): boolean;
    clear(): void;
    flipBorders(): void;
}
export {};
