"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFormatterHTML = void 0;
function outputFormatterHTML(renderData, options) {
    var cellConfig = renderData.cellConfig, cellValueRendered = renderData.cellValueRendered, columnHeaders = renderData.columnHeaders, columns = renderData.columns, rows = renderData.rows, startX = renderData.startX, startY = renderData.startY;
    var tab = columnHeaders ? '  ' : '';
    var out = '<table>\n';
    for (var y = startY; y < rows; y++) {
        if (y === -1) {
            out += '  <thead>\n';
        }
        if (columnHeaders && !y) {
            out += '  </thead>\n';
            out += '  <tbody>\n';
        }
        out += tab + '  <tr>\n';
        var tag = (y === -1 ? 'th' : 'td');
        for (var x = startX; x < columns; x++) {
            var styles = [];
            var link1 = '';
            var link2 = '';
            var config = cellConfig[x][y];
            if (options === null || options === void 0 ? void 0 : options.styles) {
                config.color && config.color !== 'default' && styles.push('color: ' + config.color);
                config.bold && styles.push('font-weight: bold');
                config.italic && styles.push('font-style: italic');
                config.align && styles.push('text-align: ' + config.align);
            }
            if (config.link) {
                link1 = "<a href=\"".concat(config.link, "\">");
                link2 = '</a>';
            }
            var content = cellValueRendered[x][y].split('<').join('&lt;').split('>').join('&gt;').split('\n').join('<br>').trim() ||
                (link1 ? 'link' : '');
            out += "".concat(tab, "    <").concat(tag).concat(content && styles.length ? " style=\"".concat(styles.join('; '), "\"") : '', ">").concat(link1).concat(content).concat(link2, "</").concat(tag, ">\n");
        }
        out += tab + '  </tr>\n';
    }
    if (columnHeaders) {
        out += '  </tbody>\n';
    }
    return out + '</table>\n';
}
exports.outputFormatterHTML = outputFormatterHTML;
