import { TableRenderData } from './table-render-data.class';
import { TRBL } from './trbl.type';
declare type TLBRSeparator = [TRBL, number];
/**
 * Border data
 */
export declare class TableRenderBorderData {
    /**
     * border grid and content logical description (sep = TLBRSeparator, i.e [TRBL, multiplier])
     * edge  pad  content  pad  edge  eol
     * [sep, sep,   sep,   sep, sep, enter]
     * [sep, sep, line[i], sep, sep, enter] x lines.length
     * [sep, sep,   sep,   sep, sep, enter]
     **/
    readonly grid: (TLBRSeparator | string)[][][][];
    /** Map of horizontal (top/bottom) borders on (x, y) coordinates (+ 1 closing row) */
    readonly horizontal: boolean[][];
    /** Indication of at least 1 horizontal border for each y coordinate (+ 1 closing row) */
    readonly horizontalSerparation: boolean[];
    /** Map of vertical (left/right) borders on (x, y) coordinates (+ 1 closing column) */
    readonly vertical: boolean[][];
    /** Indication of at least 1 vertical border for each x coordinate (+ 1 closing column) */
    readonly verticalSerparation: boolean[];
    /**
     * Instantiate border info object, set minimum data
     * @param renderData data source
     */
    constructor(renderData: TableRenderData);
    /**
     * Get the Top|Left|Bottom|Right bitmask value for crossing
     * @param x coordinate
     * @param y coordinate
     * @returns TRBL position
     */
    crossingID(x: number, y: number): TRBL;
}
export {};
