"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableRenderData = void 0;
var cell_class_1 = require("./cell/cell.class");
var config_class_1 = require("./config/config.class");
var table_render_border_data_class_1 = require("./table-render-border-data.class");
var table_snapshot_class_1 = require("./table-snapshot.class");
var numberishRx = /^[0-9\.\-,%\s]*$/;
/**
 * Render information for custom table formatters
 */
var TableRenderData = /** @class */ (function (_super) {
    __extends(TableRenderData, _super);
    /**
     * Instantiate render data
     * @param snapshot Table data snapshot
     */
    function TableRenderData(snapshot, preferences) {
        var _this = _super.call(this, snapshot) || this;
        /** processed cell values on (x, y) coordinates */
        _this.cellValueRendered = [];
        /** processed cell values split into fixed-width lines on (x, y) coordinates */
        _this.cellValueRenderedMultiline = [];
        /** processed column width on (x) coordinate */
        _this.columnWidth = [];
        /** processed row height (line count) on (y) coordinate */
        _this.rowHeight = [];
        var _a = _this, cellConfig = _a.cellConfig, cellValue = _a.cellValue, cellValueRendered = _a.cellValueRendered, cellValueRenderedMultiline = _a.cellValueRenderedMultiline, columnWidth = _a.columnWidth, columns = _a.columns, rowHeight = _a.rowHeight, rows = _a.rows, startX = _a.startX, startY = _a.startY;
        var _loop_1 = function (x) {
            cellValueRendered[x] = [];
            cellValueRenderedMultiline[x] = [];
            var _loop_2 = function (y) {
                var renderConfig = cellConfig[x][y];
                var rendererFn = (renderConfig.renderer || cell_class_1.Cell.defaultRenderer);
                var rendered = cellValueRendered[x][y] = rendererFn(cellValue[x][y], x, y, renderConfig, snapshot);
                if (!renderConfig.align) {
                    if (x >= 0 && y >= 0 && preferences.numberAlign && rendered.match(numberishRx)) {
                        renderConfig.align = config_class_1.Config.sanitizeAlign(preferences.numberAlign);
                    }
                    else {
                        renderConfig.align = config_class_1.Config.sanitizeAlign(preferences.align);
                    }
                }
                var maxHeight = Math.min(renderConfig.maxHeight || 1000, renderConfig.height || 1000);
                var renderedLines = rendered.split('\n');
                if (renderedLines.length > maxHeight) {
                    renderedLines = renderedLines.slice(0, renderConfig.maxHeight);
                }
                rowHeight[y] = Math.max(rowHeight[y] || 0, renderedLines.length);
                var rerendered = renderedLines.join('\n');
                var maxWidth = Math.min(renderConfig.maxWidth || 1000, renderConfig.width || 1000);
                cellValueRenderedMultiline[x][y] = rerendered.split('\n').map(function (line) {
                    var origLen = line.length;
                    var len = Math.min(maxWidth, origLen);
                    columnWidth[x] = Math.max(columnWidth[x] || 0, len);
                    return line.substring(0, len);
                });
            };
            for (var y = startY; y < rows; y++) {
                _loop_2(y);
            }
        };
        for (var x = startX; x < columns; x++) {
            _loop_1(x);
        }
        // render vertical & horizontal alignment in cellValueRenderedMultiline
        for (var x = startX; x < columns; x++) {
            for (var y = startY; y < rows; y++) {
                var _b = cellConfig[x][y], align = _b.align, valign = _b.valign;
                var lines = cellValueRenderedMultiline[x][y];
                var height = rowHeight[y];
                var count = 0;
                while (lines.length < height) {
                    if (valign === 'bottom') {
                        lines.unshift('');
                    }
                    else if (valign === 'middle') {
                        if (count % 2) {
                            lines.push('');
                        }
                        else {
                            lines.unshift('');
                        }
                        count++;
                    }
                    else {
                        lines.push('');
                    }
                }
                count = 0;
                for (var i = 0; i < height; i++) {
                    while (lines[i].length < columnWidth[x]) {
                        if (align === 'right') {
                            lines[i] = ' ' + lines[i];
                        }
                        else if (align === 'center') {
                            if (count % 2) {
                                lines[i] = ' ' + lines[i];
                            }
                            else {
                                lines[i] += ' ';
                            }
                            count++;
                        }
                        else {
                            lines[i] += ' ';
                        }
                    }
                }
            }
        }
        _this.borders = new table_render_border_data_class_1.TableRenderBorderData(_this);
        return _this;
    }
    return TableRenderData;
}(table_snapshot_class_1.TableSnapshot));
exports.TableRenderData = TableRenderData;
