"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function expression(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("expression");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { precedenceGroup, attributeGroup, prefixLogicalExpression, postfixAssertion, infixAssertion } = yard.post("expression");
            const children = [
                ...precedenceGroup,
                ...attributeGroup,
                ...prefixLogicalExpression,
                ...postfixAssertion,
                ...infixAssertion
            ];
            if (children.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 expression, but got ${children.length};`);
            }
            yard.tracks.expression.push(children[0]);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.expression = expression;
//# sourceMappingURL=expression.js.map