"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function filter(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("filter");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { infixLogicalExpression, expression } = yard.post("filter");
            const children = [...infixLogicalExpression, ...expression];
            if (children.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 filter, but got ${children.length};`);
            }
            yard.tracks.filter.push(children[0]);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.filter = filter;
//# sourceMappingURL=filter.js.map