"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function prefixLogicalExpression(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("prefixLogicalExpression");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { prefixLogicalExpressionOperator, precedenceGroup } = yard.post("prefixLogicalExpression");
            if (prefixLogicalExpressionOperator.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 prefixLogicalExpressionOperator, but got ${prefixLogicalExpressionOperator.length};`);
            }
            if (precedenceGroup.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 precedenceGroup, but got ${precedenceGroup.length};`);
            }
            yard.tracks.prefixLogicalExpression.push((data) => prefixLogicalExpressionOperator[0](precedenceGroup[0], data));
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.prefixLogicalExpression = prefixLogicalExpression;
//# sourceMappingURL=prefixLogicalExpression.js.map