/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.incus;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.BaseElevationHandler;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.system.incus.IncusCommandView;
import io.xpipe.ext.system.incus.IncusInstallStore;
import java.util.Objects;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="incusContainer")
@JsonDeserialize(builder=IncusContainerStoreBuilderImpl.class)
public final class IncusContainerStore
implements ShellStore,
FixedChildStore,
StatefulDataStore<ContainerStoreState>,
StartableStore,
StoppableStore,
PauseableStore,
NameableStore {
    private final DataStoreEntryRef<IncusInstallStore> install;
    private final String containerName;
    private final IdentityValue identity;

    public Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.install);
        Validators.isType(this.install, IncusInstallStore.class);
        this.install.checkComplete();
        Validators.nonNull((Object)this.containerName);
        if (this.identity != null) {
            this.identity.checkComplete();
        }
    }

    public OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.containerName));
    }

    public FixedChildStore merge(FixedChildStore other) {
        IncusContainerStore o = (IncusContainerStore)other;
        return ((IncusContainerStoreBuilder)this.toBuilder().identity(this.identity != null ? this.identity : o.identity)).build();
    }

    public ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            final /* synthetic */ IncusContainerStore this$0;
            {
                IncusContainerStore incusContainerStore = this$0;
                Objects.requireNonNull(incusContainerStore);
                this.this$0 = incusContainerStore;
            }

            public ShellControl control(ShellControl parent) throws Exception {
                this.this$0.refreshContainerState(((ShellStore)((IncusInstallStore)this.this$0.getInstall().getStore()).getHost().getStore()).getOrStartSession());
                String user = this.this$0.identity != null ? this.this$0.identity.unwrap().getUsername().retrieveUsername() : null;
                ShellControl sc = new IncusCommandView(parent).exec(this.this$0.containerName, user, () -> {
                    ContainerStoreState state = (ContainerStoreState)this.this$0.getState();
                    boolean alpine = state.getOsName() != null && state.getOsName().toLowerCase().contains("alpine");
                    return alpine;
                });
                sc.withSourceStore((DataStore)this.this$0);
                if (this.this$0.identity != null && this.this$0.identity.unwrap().getPassword() != null) {
                    sc.setElevationHandler(new BaseElevationHandler((DataStore)this.this$0, this.this$0.identity.unwrap().getPassword()).orElse(sc.getElevationHandler()));
                }
                sc.withShellStateInit((StatefulDataStore)this.this$0);
                sc.onStartupFail(throwable -> {
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    ContainerStoreState s = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)this.this$0.getState()).toBuilder().running(Boolean.valueOf(false))).containerState("Connection failed").build();
                    this.this$0.setState((DataStoreState)s);
                });
                return sc;
            }

            public ShellStore getParentStore() {
                return (ShellStore)((IncusInstallStore)this.this$0.getInstall().getStore()).getHost().getStore();
            }
        };
    }

    private void refreshContainerState(ShellControl sc) throws Exception {
        ContainerStoreState state = (ContainerStoreState)this.getState();
        IncusCommandView view = new IncusCommandView(sc);
        String displayState = view.queryContainerState(this.containerName);
        boolean running = "RUNNING".equals(displayState);
        ContainerStoreState newState = ((ContainerStoreState.ContainerStoreStateBuilder)state.toBuilder().containerState(displayState).running(Boolean.valueOf(running))).build();
        this.setState((DataStoreState)newState);
    }

    public void start() throws Exception {
        ShellControl sc = ((ShellStore)((IncusInstallStore)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        IncusCommandView view = new IncusCommandView(sc);
        view.start(this.containerName);
        this.refreshContainerState(sc);
    }

    public void stop() throws Exception {
        ShellControl sc = ((ShellStore)((IncusInstallStore)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        IncusCommandView view = new IncusCommandView(sc);
        view.stop(this.containerName);
        this.refreshContainerState(sc);
    }

    public void pause() throws Exception {
        ShellControl sc = ((ShellStore)((IncusInstallStore)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        IncusCommandView view = new IncusCommandView(sc);
        view.pause(this.containerName);
        this.refreshContainerState(sc);
    }

    public String getName() {
        return this.containerName;
    }

    @Generated
    protected IncusContainerStore(IncusContainerStoreBuilder<?, ?> b) {
        this.install = b.install;
        this.containerName = b.containerName;
        this.identity = b.identity;
    }

    @Generated
    public static IncusContainerStoreBuilder<?, ?> builder() {
        return new IncusContainerStoreBuilderImpl();
    }

    @Generated
    public IncusContainerStoreBuilder<?, ?> toBuilder() {
        return new IncusContainerStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncusContainerStore)) {
            return false;
        }
        IncusContainerStore other = (IncusContainerStore)o;
        DataStoreEntryRef<IncusInstallStore> this$install = this.getInstall();
        DataStoreEntryRef<IncusInstallStore> other$install = other.getInstall();
        if (this$install == null ? other$install != null : !this$install.equals(other$install)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        IdentityValue this$identity = this.getIdentity();
        IdentityValue other$identity = other.getIdentity();
        return !(this$identity == null ? other$identity != null : !this$identity.equals(other$identity));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<IncusInstallStore> $install = this.getInstall();
        result = result * 59 + ($install == null ? 43 : $install.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        IdentityValue $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IncusContainerStore(install=" + String.valueOf(this.getInstall()) + ", containerName=" + this.getContainerName() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public DataStoreEntryRef<IncusInstallStore> getInstall() {
        return this.install;
    }

    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    @Generated
    public IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public IncusContainerStore(DataStoreEntryRef<IncusInstallStore> install, String containerName, IdentityValue identity) {
        this.install = install;
        this.containerName = containerName;
        this.identity = identity;
    }

    @Generated
    public static abstract class IncusContainerStoreBuilder<C extends IncusContainerStore, B extends IncusContainerStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<IncusInstallStore> install;
        @Generated
        private String containerName;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C instance) {
            IncusContainerStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(IncusContainerStore instance, IncusContainerStoreBuilder<?, ?> b) {
            b.install(instance.install);
            b.containerName(instance.containerName);
            b.identity(instance.identity);
        }

        @Generated
        public B install(DataStoreEntryRef<IncusInstallStore> install) {
            this.install = install;
            return this.self();
        }

        @Generated
        public B containerName(String containerName) {
            this.containerName = containerName;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identity) {
            this.identity = identity;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IncusContainerStore.IncusContainerStoreBuilder(install=" + String.valueOf(this.install) + ", containerName=" + this.containerName + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="incusContainer")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class IncusContainerStoreBuilderImpl
    extends IncusContainerStoreBuilder<IncusContainerStore, IncusContainerStoreBuilderImpl> {
        @Generated
        private IncusContainerStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected IncusContainerStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IncusContainerStore build() {
            return new IncusContainerStore(this);
        }
    }
}

