/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.secret.SecretStrategyChoiceConfig;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.base.identity.IdentityStoreProvider;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;

public class LocalIdentityStoreProvider
extends IdentityStoreProvider {
    public UUID getTargetCategory(DataStore store, UUID target) {
        DataStoreCategory cat = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(target).orElseThrow();
        boolean inLocal = DataStorage.get().getCategoryParentHierarchy(cat).stream().anyMatch(dataStoreCategory -> dataStoreCategory.getUuid().equals(DataStorage.LOCAL_IDENTITIES_CATEGORY_UUID));
        return inLocal ? target : DataStorage.LOCAL_IDENTITIES_CATEGORY_UUID;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        LocalIdentityStore st = (LocalIdentityStore)store.getValue();
        SimpleStringProperty user = new SimpleStringProperty(st.getUsername().get());
        SimpleObjectProperty pass = new SimpleObjectProperty((Object)st.getPassword());
        SimpleObjectProperty identity = new SimpleObjectProperty((Object)st.getSshIdentity());
        SshIdentityStrategyChoiceConfig sshIdentityChoiceConfig = SshIdentityStrategyChoiceConfig.builder().allowAgentForward(true).allowKeyFileSync(false).perUserKeyFileCheck(() -> false).build();
        OptionsBuilder passwordChoice = OptionsChoiceBuilder.builder().allowNull(false).property((Property)pass).customConfiguration((Object)SecretStrategyChoiceConfig.builder().allowNone(true).build()).available(SecretRetrievalStrategy.getSubclasses()).build().build();
        return new OptionsBuilder().nameAndDescription("username").addString((Property)user).name("passwordAuthentication").description("passwordAuthenticationDescription").sub(passwordChoice, (Property)pass).name("keyAuthentication").description("keyAuthenticationDescription").documentationLink(DocumentationLink.SSH_KEYS).sub(OptionsChoiceBuilder.builder().allowNull(false).property((Property)identity).customConfiguration((Object)sshIdentityChoiceConfig).available(SshIdentityStrategy.getSubclasses()).build().build(), (Property)identity).bind(() -> ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username(user.get())).password((EncryptedValue<SecretRetrievalStrategy>)(st.getEncryptedPassword() != null ? st.getEncryptedPassword().withValue((Object)((SecretRetrievalStrategy)pass.get())) : EncryptedValue.of((Object)((SecretRetrievalStrategy)pass.get()))))).sshIdentity((EncryptedValue<SshIdentityStrategy>)(st.getEncryptedSshIdentity() != null ? st.getEncryptedSshIdentity().withValue((Object)((SshIdentityStrategy)identity.get())) : EncryptedValue.of((Object)((SshIdentityStrategy)identity.get()))))).build(), new Property[]{store}).buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().password((EncryptedValue<SecretRetrievalStrategy>)EncryptedValue.of((Object)new SecretNoneStrategy()))).sshIdentity((EncryptedValue<SshIdentityStrategy>)EncryptedValue.of((Object)new NoIdentityStrategy()))).build();
    }

    public String getId() {
        return "localIdentity";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(LocalIdentityStore.class);
    }
}

