/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.ext.DataStorageExtensionProvider;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.PredefinedScriptGroup;
import io.xpipe.ext.base.script.PredefinedScriptStore;
import io.xpipe.ext.base.script.ScriptGroupStore;
import io.xpipe.ext.base.script.ScriptStore;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;

public class ScriptDataStorageProvider
extends DataStorageExtensionProvider {
    public void storageInit() {
        if (!AppProperties.get().isInitialLaunch()) {
            return;
        }
        if (AppProperties.get().isTest()) {
            return;
        }
        DataStorage.get().addStoreEntryIfNotPresent(DataStoreEntry.createNew((UUID)UUID.fromString("a9945ad2-db61-4304-97d7-5dc4330691a7"), (UUID)DataStorage.CUSTOM_SCRIPTS_CATEGORY_UUID, (String)"My scripts", (DataStore)ScriptGroupStore.builder().build()));
        for (PredefinedScriptGroup predefinedScriptGroup : PredefinedScriptGroup.values()) {
            ScriptStore store = ((ScriptGroupStore.ScriptGroupStoreBuilder)ScriptGroupStore.builder().description(predefinedScriptGroup.getDescription())).build();
            DataStoreEntry e = DataStorage.get().addStoreEntryIfNotPresent(DataStoreEntry.createNew((UUID)UUID.nameUUIDFromBytes(("a " + predefinedScriptGroup.getName()).getBytes(StandardCharsets.UTF_8)), (UUID)DataStorage.PREDEFINED_SCRIPTS_CATEGORY_UUID, (String)predefinedScriptGroup.getName(), (DataStore)store));
            DataStorage.get().updateEntryStore(e, (DataStore)store);
            e.setExpanded(predefinedScriptGroup.isExpanded());
            predefinedScriptGroup.setEntry((DataStoreEntryRef<ScriptGroupStore>)e.ref());
        }
        for (Enum enum_ : PredefinedScriptStore.values()) {
            Optional previous = DataStorage.get().getStoreEntryIfPresent(((PredefinedScriptStore)enum_).getUuid());
            ScriptStore store = ((PredefinedScriptStore)enum_).getScriptStore().get();
            if (previous.isPresent()) {
                DataStorage.get().updateEntryStore((DataStoreEntry)previous.get(), (DataStore)store);
                ((PredefinedScriptStore)enum_).setEntry((DataStoreEntryRef<ScriptStore>)((DataStoreEntry)previous.get()).ref());
                continue;
            }
            DataStoreEntry e = DataStoreEntry.createNew((UUID)((PredefinedScriptStore)enum_).getUuid(), (UUID)DataStorage.PREDEFINED_SCRIPTS_CATEGORY_UUID, (String)((PredefinedScriptStore)enum_).getName(), (DataStore)store);
            DataStorage.get().addStoreEntryIfNotPresent(e);
            ((PredefinedScriptStore)enum_).setEntry((DataStoreEntryRef<ScriptStore>)e.ref());
        }
    }
}

