/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.cloud;

import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.cloud.d;
import io.xpipe.ext.proc.cloud.e;
import io.xpipe.ext.proc.cloud.g;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import java.util.ArrayList;
import lombok.Generated;

public abstract class b<T extends g, S extends d>
extends io.xpipe.ext.proc.ssh.e<S>
implements e<T, S> {
    protected final DataStoreEntryRef<T> parent;
    protected final DataStoreEntryRef<NetworkTunnelStore> gateway;
    protected final Integer port;
    protected final IdentityValue identity;
    protected final Boolean dontInteractWithSystem;
    protected final Boolean forwardX11;
    protected final Boolean jumpServer;
    protected final String additionalOptions;

    @Override
    public Class<S> getStateClass() {
        return d.class;
    }

    public abstract a<?, ?, ?, ?> toBuilder();

    protected abstract void refreshState(boolean var1);

    public void checkComplete() {
        Validators.nonNull(this.gateway);
        Validators.isType(this.gateway, NetworkTunnelStore.class);
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        this.gateway.checkComplete();
        io.xpipe.ext.proc.ssh.g.aH(this.additionalOptions);
        this.checkValidGatewayChain();
    }

    public boolean isPerUser() {
        return this.identity.isPerUser();
    }

    @Override
    public io.xpipe.ext.proc.ssh.g toConfigHost() {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(new KeyValue("HostName", ((io.xpipe.ext.proc.ssh.e)this).getHostAddress().get()));
        arrayList.add(new KeyValue("Port", String.valueOf(this.port)));
        arrayList.add(new KeyValue("User", ((io.xpipe.ext.proc.ssh.e)this).getUser().retrieveUsername()));
        io.xpipe.ext.proc.ssh.g g2 = this.getAdditionalOptions();
        if (g2 != null) {
            arrayList.addAll(g2.cu().cE());
        }
        return new io.xpipe.ext.proc.ssh.g(new g.a(this.distinctConfigHostName(), arrayList));
    }

    @Override
    protected boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected boolean hasX11Forward() {
        return this.forwardX11 != null && this.forwardX11 != false;
    }

    @Override
    public SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.identity.unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretNoneStrategy();
    }

    @Override
    public DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return this.gateway;
    }

    @Override
    public HostAddress getHostAddress() {
        HostAddress hostAddress = ((d)this.getState()).getAddress();
        if (hostAddress != null) {
            return hostAddress;
        }
        return HostAddress.empty();
    }

    @Override
    public UsernameStrategy getUser() {
        return this.identity.unwrap().getUsername();
    }

    @Override
    public int getPort() {
        if (this.port != null) {
            return this.port;
        }
        return 22;
    }

    @Override
    public CommandBuilder buildBaseCommand() {
        this.refreshState(true);
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"-p", "" + this.getEffectivePort()}).addQuoted(((io.xpipe.ext.proc.ssh.e)this).getUser().retrieveUsername() + "@" + this.getEffectiveHostName());
        return commandBuilder;
    }

    @Override
    public boolean isJumpServer() {
        return this.jumpServer != null && this.jumpServer != false;
    }

    @Override
    public SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoIdentityStrategy();
    }

    @Override
    protected boolean hasTunnels() {
        return false;
    }

    @Override
    public io.xpipe.ext.proc.ssh.g getAdditionalOptions() {
        if (this.additionalOptions != null) {
            io.xpipe.ext.proc.ssh.g g2 = io.xpipe.ext.proc.ssh.g.aH(this.additionalOptions);
            return g2;
        }
        return null;
    }

    @Generated
    protected b(a<T, S, ?, ?> a2) {
        super(a2);
        this.parent = a2.parent;
        this.gateway = a2.gateway;
        this.port = a2.port;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.forwardX11 = a2.forwardX11;
        this.jumpServer = a2.jumpServer;
        this.additionalOptions = a2.additionalOptions;
    }

    @Override
    @Generated
    public DataStoreEntryRef<T> getParent() {
        return this.parent;
    }

    @Generated
    public IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Generated
    public Boolean getJumpServer() {
        return this.jumpServer;
    }

    @Override
    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof b)) {
            return false;
        }
        Object object2 = (b)object;
        if (!((b)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((io.xpipe.ext.proc.ssh.e)this).getPort() != ((io.xpipe.ext.proc.ssh.e)object2).getPort()) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        IdentityValue identityValue = ((b)object2).getDontInteractWithSystem();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = this.getForwardX11();
        identityValue = ((b)object2).getForwardX11();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = this.getJumpServer();
        identityValue = ((b)object2).getJumpServer();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = this.getParent();
        identityValue = ((b)object2).getParent();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = ((io.xpipe.ext.proc.ssh.e)this).getGateway();
        identityValue = ((io.xpipe.ext.proc.ssh.e)object2).getGateway();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = this.getIdentity();
        identityValue = ((b)object2).getIdentity();
        if (object == null ? identityValue != null : !object.equals(identityValue)) {
            return false;
        }
        object = this.getAdditionalOptions();
        object2 = ((b)object2).getAdditionalOptions();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof b;
    }

    @Override
    @Generated
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 59 + ((io.xpipe.ext.proc.ssh.e)this).getPort();
        Object object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getForwardX11();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getJumpServer();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getParent();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = ((io.xpipe.ext.proc.ssh.e)this).getGateway();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public String toString() {
        return "CloudHostSshStore(super=" + super.toString() + ", parent=" + String.valueOf(this.getParent()) + ", gateway=" + String.valueOf(((io.xpipe.ext.proc.ssh.e)this).getGateway()) + ", port=" + ((io.xpipe.ext.proc.ssh.e)this).getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", forwardX11=" + this.getForwardX11() + ", jumpServer=" + this.getJumpServer() + ", additionalOptions=" + String.valueOf(this.getAdditionalOptions()) + ")";
    }

    @Generated
    public static abstract class a<T extends g, S extends d, C extends b<T, S>, B extends a<T, S, C, B>>
    extends e.a<S, C, B> {
        @Generated
        private DataStoreEntryRef<T> parent;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean forwardX11;
        @Generated
        private Boolean jumpServer;
        @Generated
        private String additionalOptions;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static <T extends g, S extends d> void $fillValuesFromInstanceIntoBuilder(b<T, S> b2, a<T, S, ?, ?> a2) {
            a2.parent(b2.parent);
            a2.gateway(b2.gateway);
            a2.port(b2.port);
            a2.identity(b2.identity);
            a2.dontInteractWithSystem(b2.dontInteractWithSystem);
            a2.forwardX11(b2.forwardX11);
            a2.jumpServer(b2.jumpServer);
            a2.additionalOptions(b2.additionalOptions);
        }

        @Generated
        public B parent(DataStoreEntryRef<T> dataStoreEntryRef) {
            this.parent = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return (B)this.self();
        }

        @Generated
        public B jumpServer(Boolean bl) {
            this.jumpServer = bl;
            return (B)this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CloudHostSshStore.CloudHostSshStoreBuilder(super=" + super.toString() + ", parent=" + String.valueOf(this.parent) + ", gateway=" + String.valueOf(this.gateway) + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", forwardX11=" + this.forwardX11 + ", jumpServer=" + this.jumpServer + ", additionalOptions=" + this.additionalOptions + ")";
        }
    }
}

