/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.core.AppSid;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.core.mode.AppOperationMode;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorAction;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.process.CommandConfiguration;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ElevationHandler;
import io.xpipe.app.process.LocalProcessInputStream;
import io.xpipe.app.process.LocalProcessOutputStream;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.SecretReference;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellSecurityPolicy;
import io.xpipe.app.process.ShellSpawnException;
import io.xpipe.app.process.ShellTemp;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.process.SudoCache;
import io.xpipe.app.process.TerminalInitFunction;
import io.xpipe.app.process.TerminalInitScriptConfig;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretQuery;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.terminal.TerminalLauncher;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FailableConsumer;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.f;
import io.xpipe.ext.proc.io.c;
import io.xpipe.ext.proc.io.g;
import io.xpipe.ext.proc.j;
import io.xpipe.ext.proc.k;
import io.xpipe.ext.proc.util.d;
import io.xpipe.ext.proc.util.h;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public final class e
extends j {
    private static final UUID D = UUID.randomUUID();
    private static String E;
    private static FilePath F;
    private final boolean G;
    private final 1 H = new ReentrantLock(this){
        private /* synthetic */ e N;
        {
            e e3 = e2;
            Objects.requireNonNull(e3);
            this.N = e3;
        }

        @Override
        public final void lock() {
            super.lock();
        }

        @Override
        public final void unlock() {
            if (super.isHeldByCurrentThread()) {
                super.unlock();
            }
        }
    };
    private int I = 7500;
    private Process J;
    private LocalProcessOutputStream K;
    private LocalProcessInputStream L;
    private LocalProcessInputStream M;

    public e(boolean bl) {
        this.G = bl;
        this.aj = new ElevationHandler(this){
            {
                Objects.requireNonNull(e2);
            }

            public final boolean handleRequest(UUID uUID, CountDown countDown, boolean bl, boolean bl2) {
                SecretReference secretReference = this.getSecretRef();
                SecretManager.expectAskpass((UUID)uUID, (UUID)secretReference.getSecretId(), List.of(SecretQuery.confirmElevationIfNeeded((SecretQuery)SecretQuery.prompt((boolean)true), (boolean)bl)), (SecretQuery)SecretQuery.prompt((boolean)false), List.of(), List.of(), (CountDown)countDown, (boolean)bl2);
                return true;
            }

            public final SecretReference getSecretRef() {
                return SecretReference.ofUuid((UUID)D);
            }
        };
    }

    public static void o() {
        F = null;
        E = null;
    }

    @Override
    public final ShellView view() {
        if (this.ao == null) {
            this.ao = new f(this);
        }
        return this.ao;
    }

    @Override
    public final void exitAndWait() {
        try {
            this.getLock().lock();
            this.refreshRunningState();
            if (!this.running) {
                this.h();
                return;
            }
            this.ae.accept(this);
            this.ai = true;
            if (this.J.isAlive()) {
                boolean bl = this.isAnyStreamClosed() || AppOperationMode.isInShutdown();
                if (!bl) {
                    this.getShellDialect().getDumbMode().prepareDumbExit((ShellControl)this);
                }
                this.getStdout().close();
                this.getStderr().close();
                this.getStdin().close();
                if (bl) {
                    this.J.destroy();
                }
                try {
                    this.J.waitFor(this.I, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.h();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final SudoCache getSudoCache() {
        if (this.ap == null) {
            this.ap = new h(this);
        }
        return this.ap;
    }

    private void h() {
        this.W = null;
        this.running = false;
        this.J = null;
        this.K = null;
        this.L = null;
        this.M = null;
        this.ah = false;
        this.ai = false;
    }

    public final void refreshRunningState() {
        this.running = this.J != null && this.J.isAlive();
    }

    public final void closeStdin() {
        try {
            this.getLock().lock();
            if (this.J == null) {
                return;
            }
            this.getStdin().close();
            ThreadHelper.sleep((long)100L);
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final boolean isAnyStreamClosed() {
        if (this.J == null) {
            return false;
        }
        return this.getStdin().isClosed() || this.getStdout().isClosed() || this.getStderr().isClosed();
    }

    public final void close() {
        try {
            this.getLock().lock();
            if (!this.G) {
                return;
            }
            TrackEvent.withTrace((String)"Closing local shell ...").handle();
            try {
                ((j)this).exitAndWait();
            }
            catch (IOException iOException) {
                this.kill();
                throw iOException;
            }
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void shutdown() {
        this.close();
    }

    public final void kill() {
        try {
            this.getLock().lock();
            if (!this.running) {
                this.h();
                return;
            }
            TrackEvent.withTrace((String)"Killing local shell ...").handle();
            this.J.destroyForcibly();
            List<ProcessHandle> list = this.J.descendants().toList();
            list.forEach(processHandle -> {
                try {
                    processHandle.destroyForcibly();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    return;
                }
            });
            this.h();
            this.af.run();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void killExternal() {
        try {
            if (!this.isRunning(true)) {
                return;
            }
            TrackEvent.withTrace((String)"Killing local shell ...").handle();
            this.J.destroyForcibly();
            List<ProcessHandle> list = this.J.descendants().toList();
            list.forEach(processHandle -> {
                try {
                    processHandle.destroyForcibly();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    return;
                }
            });
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void setExitTimeout(int n2) {
        this.I = n2;
    }

    public final void setDumbOpen(ShellOpenFunction shellOpenFunction) {
        throw new UnsupportedOperationException();
    }

    public final void setTerminalOpen(ShellOpenFunction shellOpenFunction) {
        throw new UnsupportedOperationException();
    }

    public final Optional<ShellControl> getParentControl() {
        return Optional.empty();
    }

    public final void closeStdout() {
        try {
            this.getLock().lock();
            if (this.J == null) {
                return;
            }
            this.getStdout().close();
            this.getStderr().close();
            ThreadHelper.sleep((long)100L);
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final List<UUID> getExitUuids() {
        return List.of();
    }

    public final ParentSystemAccess getParentSystemAccess() {
        return ParentSystemAccess.identity();
    }

    public final void setParentSystemAccess(ParentSystemAccess parentSystemAccess) {
        throw new UnsupportedOperationException();
    }

    public final ParentSystemAccess getLocalSystemAccess() {
        return ParentSystemAccess.identity();
    }

    public final boolean isLocal() {
        return true;
    }

    public final ShellDialect getOriginalShellDialect() {
        return this.getShellDialect();
    }

    public final void setOriginalShellDialect(ShellDialect shellDialect) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ShellControl start() {
        try {
            try {
                this.getLock().lock();
                if (this.J != null && !this.J.isAlive()) {
                    this.h();
                }
                if (this.running) {
                    e e2 = this;
                    return e2;
                }
                if (this.ah) {
                    e e3 = this;
                    return e3;
                }
                this.p();
                e e4 = this;
                return e4;
            }
            catch (Throwable throwable) {
                this.ag.accept(throwable);
                Object object = this.Y.convert(throwable);
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                ErrorEvent.ErrorEventBuilder errorEventBuilder = ErrorEventFactory.fromThrowable((Throwable)object).description("Unable to launch local shell " + io.xpipe.ext.proc.h.get().getEffectiveLocalDialect().getDisplayName()).documentationLink(this.G ? DocumentationLink.LOCAL_SHELL_OCCASIONAL : DocumentationLink.LOCAL_SHELL_ERROR);
                Object object2 = io.xpipe.ext.proc.h.get().getNextFallbackDialect();
                object2 = new ErrorAction(){
                    private /* synthetic */ ShellDialect O;
                    private /* synthetic */ AtomicBoolean P;
                    {
                        this.O = shellDialect;
                        this.P = atomicBoolean;
                        Objects.requireNonNull(e2);
                    }

                    public final String getName() {
                        return "Fall back to " + this.O.getDisplayName() + " as an alternative shell";
                    }

                    public final String getDescription() {
                        return "Attempt to handle all operations only using " + this.O.getDisplayName();
                    }

                    public final boolean handle(ErrorEvent errorEvent) {
                        this.P.set(true);
                        return true;
                    }
                };
                if (!this.G) {
                    errorEventBuilder.customAction((ErrorAction)object2);
                }
                errorEventBuilder.handle();
                if (!atomicBoolean.get()) throw object;
                try {
                    io.xpipe.ext.proc.h.get().toggleFallbackShell();
                    this.p();
                    object = this;
                    return object;
                }
                catch (Exception exception) {
                    this.ag.accept(throwable);
                    Throwable throwable2 = this.Y.convert((Throwable)exception);
                    ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)exception).documentationLink(DocumentationLink.LOCAL_SHELL_ERROR));
                    throw throwable2;
                }
            }
            finally {
                ((ReentrantLock)this.H).unlock();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            throw throwable;
        }
    }

    public final LocalProcessInputStream getStdout() {
        return this.L;
    }

    public final LocalProcessOutputStream getStdin() {
        return this.K;
    }

    public final LocalProcessInputStream getStderr() {
        return this.M;
    }

    public final void checkLicenseOrThrow() {
        for (LicensedFeature licensedFeature : this.ac) {
            licensedFeature.throwIfUnsupported();
        }
    }

    public final String prepareIntermediateTerminalOpen(TerminalInitFunction terminalInitFunction, TerminalInitScriptConfig terminalInitScriptConfig, WorkingDirectoryFunction workingDirectoryFunction) {
        ShellControl shellControl = this.getActiveReplacementBackgroundSession().orElseThrow();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(shellControl.getShellDialect().prepareTerminalEnvironmentCommands());
        arrayList.add(shellControl.getShellDialect().getCdCommand(AppSystemInfo.ofCurrent().getUserHome().toString()));
        arrayList.add(shellControl.getShellDialect().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object2 = shellControl.getShellDialect().prepareEnvironmentForCustomTerminalScripts();
        if (object2 != null) {
            arrayList2.add(object2);
        }
        for (ShellTerminalInitCommand bl : this.Z) {
            Optional optional;
            if (!bl.canPotentiallyRunInDialect(shellControl.getShellDialect()) || !(optional = bl.terminalContent(shellControl)).isPresent()) continue;
            arrayList2.add((String)optional.get());
        }
        object2 = terminalInitFunction.isSpecified() ? terminalInitFunction.apply(shellControl) : null;
        String string = object2 == null && terminalInitScriptConfig.getTerminalSpecificCommands().isSpecified() ? terminalInitScriptConfig.getTerminalSpecificCommands().apply(shellControl) : null;
        if (string != null) {
            arrayList2.add(string);
        }
        if (object2 != null) {
            arrayList2.add(object2);
        }
        boolean bl = this.d((String)object2);
        terminalInitFunction = TerminalLauncher.constructTerminalInitFile((ShellDialect)shellControl.getShellDialect(), (ShellControl)shellControl, (WorkingDirectoryFunction)workingDirectoryFunction, arrayList, arrayList2, (TerminalInitScriptConfig)terminalInitScriptConfig, (boolean)bl);
        TrackEvent.withDebug((String)"Writing open init script").tag("initFile", (Object)terminalInitFunction).tag("preInit", arrayList).tag("postInit", arrayList2).handle();
        return shellControl.getShellDialect().terminalInitCommand(shellControl, terminalInitFunction.toString(), bl);
    }

    public final ShellControl withSecurityPolicy(ShellSecurityPolicy shellSecurityPolicy) {
        return this;
    }

    public final ShellSecurityPolicy getEffectiveSecurityPolicy() {
        return new ShellSecurityPolicy(this){
            {
                Objects.requireNonNull(e2);
            }

            public final boolean permitTempScriptCreation() {
                return true;
            }
        };
    }

    public final String buildElevatedCommand(CommandConfiguration commandConfiguration, String string, UUID uUID, CountDown countDown, String string2) {
        e e2 = this;
        return this.getShellDialect().getAskpass().elevateDumbCommand((ShellControl)this, uUID, e2.a(e2.aj), countDown, string, string2, commandConfiguration);
    }

    public final void restart() {
        try {
            this.getLock().lock();
            this.close();
            this.start();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final ShellControl elevated(ElevationFunction elevationFunction) {
        return this;
    }

    public final Optional<ShellControl> getActiveReplacementBackgroundSession() {
        DataStorage dataStorage = DataStorage.get();
        if (dataStorage == null) {
            return Optional.of(new e(true).start());
        }
        dataStorage = (ShellStore)dataStorage.local().getStore();
        return Optional.of(dataStorage.getOrStartSession());
    }

    public final void p() {
        try {
            this.J = e.t();
            this.A = this.J.info().commandLine().orElse(null);
            this.W = UUID.randomUUID();
            TrackEvent.withTrace((String)"Starting local shell").tag("command", (Object)this.A).tag("id", (Object)this.getUuid()).handle();
            this.K = this.s();
            this.L = this.q();
            this.M = this.r();
            this.running = true;
            Object object = CountDown.of();
            object.start(OsType.ofLocal() == OsType.WINDOWS ? 15000L : 10000L);
            this.ah = true;
            d d22 = new d(this, StandardCharsets.US_ASCII, this.A, UUID.randomUUID().toString(), (CountDown)object, null);
            d22.dQ();
            this.ak = d22.eb();
            this.an = d22.dL();
            if (this.getTtyState() != ShellTtyState.NONE) {
                object = new UnsupportedOperationException("Local background shell has a tty allocated");
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)object).documentationLink(DocumentationLink.TTY));
                throw object;
            }
            this.ak.getDumbMode().throwIfUnsupported();
            TrackEvent.withTrace((String)"Local shell started up").tag("elapsed", (Object)(object.getMillisecondsElapsed() + "ms")).handle();
            this.ak.getDumbMode().prepareImmediateDumbInit((ShellControl)this);
            if (this.X == null) {
                this.X = this.getShellDialect().determineCharset((ShellControl)this);
            }
            this.osType = OsType.ofLocal().toAny();
            this.ak.getDumbMode().prepareDumbInit((ShellControl)this);
            if (!this.isRunning(true)) {
                throw new IllegalStateException("Local shell exited upon startup");
            }
            if (this.ad == null) {
                this.ad = F != null ? F : io.xpipe.ext.proc.util.e.Q(this);
                F = this.ad;
            }
            ShellTemp.checkTempDirectory((ShellControl)this);
            if (this.osName == null) {
                this.osName = E != null ? E : io.xpipe.ext.proc.util.e.R(this);
                E = this.osName;
            }
            e e2 = this;
            e2.writeLine(e2.H().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
            if (this.al.isSpecified()) {
                object = this.al.apply((ShellControl)this);
                ((j)this).view().cd(object.toString());
            }
            e e3 = this;
            e3.writeLine(e3.H().addToPathVariableCommand(List.of(AppProperties.get().getDataBinDir().toString()), true));
            for (FailableConsumer failableConsumer : this.aa) {
                failableConsumer.accept((Object)this);
            }
            k.b(this);
            this.ah = false;
            return;
        }
        catch (Throwable throwable) {
            E = null;
            F = null;
            this.kill();
            throw throwable;
        }
    }

    private LocalProcessInputStream q() {
        try {
            InputStream inputStream = this.J.getInputStream();
            if (OsType.ofLocal() == OsType.WINDOWS) {
                return new io.xpipe.ext.proc.io.f(inputStream);
            }
            return new c(inputStream);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private LocalProcessInputStream r() {
        try {
            if (OsType.ofLocal() == OsType.WINDOWS) {
                return new io.xpipe.ext.proc.io.f(this.J.getErrorStream());
            }
            return new c(this.J.getErrorStream());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private LocalProcessOutputStream s() {
        try {
            if (OsType.ofLocal() == OsType.WINDOWS) {
                return new g(this.J.getOutputStream());
            }
            return new io.xpipe.ext.proc.io.d(this.J.getOutputStream());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private static Process t() {
        Object object = io.xpipe.ext.proc.h.get().getEffectiveLocalDialect().getLaunchCommand().localCommand().stream();
        object = OsType.ofLocal() == OsType.WINDOWS || !AppSid.isHasSetsid() ? object : Stream.concat(Stream.of("setsid"), object);
        object = new ProcessBuilder(object.toList());
        Object object2 = AppProperties.get().getDataDir().resolve("shell");
        FileUtils.forceMkdir((File)object2.toFile());
        ((ProcessBuilder)object).directory(object2.toFile());
        object2 = ((ProcessBuilder)object).environment();
        object2.put((String)"NO_COLOR", (String)"true");
        object2.put("TERM", "dumb");
        object2.put("LC_ALL", "C.UTF-8");
        object2.put("LANGUAGE", "C.UTF-8");
        object2.put("LANG", "C.UTF-8");
        if (OsType.ofLocal() == OsType.WINDOWS) {
            object2.remove("PSModulePath");
        }
        object2.put("DISABLE_AUTO_UPDATE", "true");
        object2.put("POWERLEVEL9K_INSTANT_PROMPT", "off");
        object2.remove("_JPACKAGE_LAUNCHER");
        if (OsType.ofLocal() == OsType.LINUX && !AppSystemInfo.ofLinux().isVirtualMachine()) {
            object2.put("ELECTRON_OZONE_PLATFORM_HINT", "auto");
        }
        try {
            return ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            throw new ShellSpawnException("Unable to launch required system shell: " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    @Generated
    public final ReentrantLock getLock() {
        return this.H;
    }
}

