/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vmware;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.FailableSupplier;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.proc.ssh.s;
import io.xpipe.ext.proc.vm.d;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import lombok.Generated;

@JsonTypeName(value="vmwareMachine")
@JsonDeserialize(builder=c.class)
public final class g
extends e<a>
implements FixedChildStore,
InternalCacheDataStore,
NameableStore,
SelfReferentialStore,
ShellStore,
StatefulDataStore<a>,
PauseableStore,
StartableStore,
StoppableStore {
    private final DataStoreEntryRef<io.xpipe.ext.proc.vmware.b> install;
    private final FilePath definitionFile;
    private final EncryptedValue<SecretRetrievalStrategy> encryptionPassword;
    private final boolean useGui;
    private final String name;

    public final void start() {
        ((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).checkLicense();
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(io.xpipe.ext.proc.vmware.a.a(this, false).add(new String[]{"start"}).addFile(this.getDefinitionFile()).add(new String[]{this.isUseGui() ? "gui" : "nogui"})).execute();
        this.refreshVmState(shellControl);
    }

    public final void stop() {
        ((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).checkLicense();
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(io.xpipe.ext.proc.vmware.a.a(this, false).add(new String[]{"stop"}).addFile(this.getDefinitionFile()).add(new String[]{"hard"})).execute();
        this.refreshVmState(shellControl);
    }

    public final void pause() {
        ((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).checkLicense();
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.vmware.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(io.xpipe.ext.proc.vmware.a.a(this, false).add(new String[]{"suspend"}).addFile(this.getDefinitionFile()).add(new String[]{"soft"})).execute();
        this.refreshVmState(shellControl);
    }

    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull(this.install);
        Validators.isType(this.install, io.xpipe.ext.proc.vmware.b.class);
        this.install.checkComplete();
        Validators.nonNull((Object)this.definitionFile);
        Validators.nonNull(this.encryptionPassword);
    }

    public final FailableSupplier<SecretValue> getPasswordSupplier() {
        return () -> {
            String string = ((a)this.getState()).getDisplayName() + "'s password";
            string = SecretManager.retrieve((SecretRetrievalStrategy)this.getIdentity().unwrap().getPassword(), (String)string, (UUID)this.getSelfEntry().getUuid(), (int)0, (boolean)true);
            if (string != null) {
                return string;
            }
            return InPlaceSecretValue.of((String)"");
        };
    }

    public final FailableSupplier<SecretValue> getEncryptionPasswordSupplier() {
        return () -> {
            String string = ((a)this.getState()).getDisplayName() + "'s encryption password";
            string = SecretManager.retrieve((SecretRetrievalStrategy)((SecretRetrievalStrategy)this.getEncryptionPassword().getValue()), (String)string, (UUID)this.getSelfEntry().getUuid(), (int)1, (boolean)true);
            if (string != null) {
                return string;
            }
            return InPlaceSecretValue.of((String)"");
        };
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.definitionFile));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (g)fixedChildStore;
        return ((b)this.toBuilder().identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getHypervisorHost() {
        if (this.install != null) {
            return ((io.xpipe.ext.proc.vmware.b)this.install.getStore()).getHost();
        }
        return null;
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        return commandBuilder -> {
            CommandBuilder commandBuilder2 = io.xpipe.ext.proc.vmware.a.a(this, true);
            commandBuilder2.add(new String[]{"runProgramInGuest"}).addFile(this.getDefinitionFile()).add(commandBuilder);
            return commandBuilder2.build(shellControl).executeAndCheck();
        };
    }

    @Override
    public final Class<a> getStateClass() {
        return a.class;
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        shellControl.requireLicensedFeature(LicenseProvider.get().getFeature("vmware"));
    }

    @Override
    public final void updateGuestState(ShellControl shellControl) {
        this.refreshVmState(shellControl);
        if (!((a)this.getState()).getRunning().booleanValue()) {
            return;
        }
        Object object = (a)this.getState();
        object = io.xpipe.ext.proc.vmware.a.a(shellControl, this, (a)((Object)object));
        this.setState((DataStoreState)object);
        object = ((a)((Object)object)).toBuilder();
        if (this.getCustomIp() == null || !this.getCustomIp().use()) {
            String string = io.xpipe.ext.proc.vmware.a.b(shellControl, this);
            ((h.a)((Object)object)).ip(string);
            this.setState(((a.a)((Object)object)).build());
        }
        boolean bl = s.a(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        ((h.a)((Object)object)).reachable(bl);
        if (!bl) {
            OsType.Any any = this.guestExecPredicate(shellControl);
            any = io.xpipe.ext.proc.util.e.a(any);
            ((h.a)((Object)object)).reachable(d.a(this, shellControl, any));
        }
        this.setState(((a.a)((Object)object)).build());
    }

    @Override
    public final void throwIfNotRunning() {
        if (!((a)this.getState()).getRunning().booleanValue()) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Virtual machine is not running or does not have vm tools installed"));
        }
    }

    private void refreshVmState(ShellControl object) {
        Object object2 = (a)this.getState();
        object2 = ((a)((Object)object2)).toBuilder();
        object = io.xpipe.ext.proc.vmware.a.a(object, this);
        ((h.a)((Object)object2)).stateString((String)object);
        boolean bl = "running".equals(object);
        ((h.a)((Object)object2)).running(bl);
        this.setState(((a.a)((Object)object2)).build());
    }

    @Generated
    protected g(b<?, ?> b2) {
        super(b2);
        this.install = b2.install;
        this.definitionFile = b2.definitionFile;
        this.encryptionPassword = b2.encryptionPassword;
        this.useGui = b2.useGui;
        this.name = b2.name;
    }

    @Generated
    public static b<?, ?> builder() {
        return new c();
    }

    @Generated
    public final b<?, ?> toBuilder() {
        return new c().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<io.xpipe.ext.proc.vmware.b> getInstall() {
        return this.install;
    }

    @Generated
    public final FilePath getDefinitionFile() {
        return this.definitionFile;
    }

    @Generated
    public final EncryptedValue<SecretRetrievalStrategy> getEncryptionPassword() {
        return this.encryptionPassword;
    }

    @Generated
    public final boolean isUseGui() {
        return this.useGui;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof g)) {
            return false;
        }
        Object object2 = (g)object;
        if (!((g)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.isUseGui() != ((g)object2).isUseGui()) {
            return false;
        }
        object = this.getInstall();
        EncryptedValue<SecretRetrievalStrategy> encryptedValue = ((g)object2).getInstall();
        if (object == null ? encryptedValue != null : !object.equals(encryptedValue)) {
            return false;
        }
        object = this.getDefinitionFile();
        encryptedValue = ((g)object2).getDefinitionFile();
        if (object == null ? encryptedValue != null : !object.equals(encryptedValue)) {
            return false;
        }
        object = this.getEncryptionPassword();
        encryptedValue = ((g)object2).getEncryptionPassword();
        if (object == null ? encryptedValue != null : !object.equals(encryptedValue)) {
            return false;
        }
        object = this.getName();
        object2 = ((g)object2).getName();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof g;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 59 + (this.isUseGui() ? 79 : 97);
        Object object = this.getInstall();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDefinitionFile();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getEncryptionPassword();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "VmwareVmStore(super=" + super.toString() + ", install=" + String.valueOf(this.getInstall()) + ", definitionFile=" + String.valueOf(this.getDefinitionFile()) + ", encryptionPassword=" + String.valueOf(this.getEncryptionPassword()) + ", useGui=" + this.isUseGui() + ", name=" + this.getName() + ")";
    }

    @Generated
    public static abstract class b<C extends g, B extends b<C, B>>
    extends e.a<a, C, B> {
        @Generated
        private DataStoreEntryRef<io.xpipe.ext.proc.vmware.b> install;
        @Generated
        private FilePath definitionFile;
        @Generated
        private EncryptedValue<SecretRetrievalStrategy> encryptionPassword;
        @Generated
        private boolean useGui;
        @Generated
        private String name;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            b.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(g g2, b<?, ?> b2) {
            b2.install(g2.install);
            b2.definitionFile(g2.definitionFile);
            b2.encryptionPassword(g2.encryptionPassword);
            b2.useGui(g2.useGui);
            b2.name(g2.name);
        }

        @Generated
        public B install(DataStoreEntryRef<io.xpipe.ext.proc.vmware.b> dataStoreEntryRef) {
            this.install = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B definitionFile(FilePath filePath) {
            this.definitionFile = filePath;
            return (B)this.self();
        }

        @Generated
        public B encryptionPassword(EncryptedValue<SecretRetrievalStrategy> encryptedValue) {
            this.encryptionPassword = encryptedValue;
            return (B)this.self();
        }

        @Generated
        public B useGui(boolean bl) {
            this.useGui = bl;
            return (B)this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "VmwareVmStore.VmwareVmStoreBuilder(super=" + super.toString() + ", install=" + String.valueOf(this.install) + ", definitionFile=" + String.valueOf(this.definitionFile) + ", encryptionPassword=" + String.valueOf(this.encryptionPassword) + ", useGui=" + this.useGui + ", name=" + this.name + ")";
        }
    }

    @JsonDeserialize(builder=b.class)
    public static final class io.xpipe.ext.proc.vmware.g$a
    extends h {
        private final String displayName;

        @Override
        public final DataStoreState mergeCopy(DataStoreState dataStoreState) {
            dataStoreState = (io.xpipe.ext.proc.vmware.g$a)dataStoreState;
            h.a a2 = this.toBuilder();
            this.mergeBuilder((h)dataStoreState, a2);
            return ((a)((Object)((a)a2).displayName(this.displayName))).build();
        }

        @Generated
        protected io.xpipe.ext.proc.vmware.g$a(a<?, ?> a2) {
            super(a2);
            this.displayName = a2.displayName;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public final a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public final String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public final String toString() {
            return "VmwareVmStore.State(displayName=" + this.getDisplayName() + ")";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof io.xpipe.ext.proc.vmware.g$a)) {
                return false;
            }
            Object object2 = (io.xpipe.ext.proc.vmware.g$a)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            object = this.getDisplayName();
            object2 = object2.getDisplayName();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof io.xpipe.ext.proc.vmware.g$a;
        }

        @Override
        @Generated
        public final int hashCode() {
            int n2 = super.hashCode();
            String string = this.getDisplayName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.vmware.g$a, B extends a<C, B>>
        extends h.a<C, B> {
            @Generated
            private String displayName;

            @Override
            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)((Object)this.self());
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(io.xpipe.ext.proc.vmware.g$a a2, a<?, ?> a3) {
                a3.displayName(a2.displayName);
            }

            @Generated
            public B displayName(String string) {
                this.displayName = string;
                return (B)((Object)this.self());
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "VmwareVmStore.State.StateBuilder(super=" + super.toString() + ", displayName=" + this.displayName + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.vmware.g$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.vmware.g$a build() {
                return new io.xpipe.ext.proc.vmware.g$a(this);
            }
        }
    }

    @JsonTypeName(value="vmwareMachine")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class c
    extends b<g, c> {
        @Generated
        private c() {
        }

        @Override
        @Generated
        public final g build() {
            return new g(this);
        }
    }
}

