/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.host;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.base.host.AbstractHostStore;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class AbstractHostStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.ABSTRACT_HOSTS;
    }

    public int getOrderPriority() {
        return 2;
    }

    public BaseRegionBuilder<?, ?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.HOST;
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return Bindings.createStringBinding(() -> {
            Integer string;
            ObservableList all = section.getAllChildren().getList();
            ObservableList shown = section.getShownChildren().getList();
            if (shown.size() == 0) {
                return null;
            }
            Integer n = string = all.size() == shown.size() ? Integer.valueOf(all.size()) : shown.size() + "/" + all.size();
            return all.size() > 0 ? (all.size() == 1 ? AppI18n.get((String)"hostHasConnection", (Object[])new Object[]{string}) : AppI18n.get((String)"hostHasConnections", (Object[])new Object[]{string})) : AppI18n.get((String)"hostNoConnections", (Object[])new Object[0]);
        }, (Observable[])new Observable[]{section.getShownChildren().getList(), section.getAllChildren().getList(), AppI18n.activeLanguage()});
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        AbstractHostStore st = (AbstractHostStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty host = new SimpleObjectProperty((Object)st.getHost());
        SimpleObjectProperty gateway = new SimpleObjectProperty(st.getTunnelGateway());
        return new OptionsBuilder().nameAndDescription("abstractHostAddress").addString((Property)host).nonNull().nameAndDescription("abstractHostGateway").addComp((BaseRegionBuilder)new StoreChoiceComp(entry, (ObjectProperty)gateway, NetworkTunnelStore.class, null, StoreViewState.get().getAllConnectionsCategory()), (Property)gateway).bind(() -> ((AbstractHostStore.AbstractHostStoreBuilder)((AbstractHostStore.AbstractHostStoreBuilder)AbstractHostStore.builder().host((String)host.getValue())).gateway((DataStoreEntryRef<NetworkTunnelStore>)((DataStoreEntryRef)gateway.getValue()))).build(), new Property[]{store}).buildDialog();
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        AbstractHostStore scriptStore = (AbstractHostStore)wrapper.getEntry().getStore().asNeeded();
        return scriptStore.getHost();
    }

    public String getDisplayIconFileName(DataStore store) {
        return "base:abstractHost_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return AbstractHostStore.builder().build();
    }

    public String getId() {
        return "abstractHost";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(AbstractHostStore.class);
    }
}

