/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.host;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.ext.base.host.HostAddressChoiceComp;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;

public final class HostAddressChoice {
    private final Property<HostAddress> value;
    private final boolean allowMutation;
    private final String translationKey;
    private final boolean includeDescription;

    public OptionsBuilder build() {
        HostAddress existing = (HostAddress)this.value.getValue();
        SimpleObjectProperty val = new SimpleObjectProperty((Object)(existing != null ? existing.get() : null));
        ObservableList list = FXCollections.observableArrayList((Collection)(existing != null ? existing.getAvailable() : new ArrayList()));
        SimpleIntegerProperty listHashProp = new SimpleIntegerProperty(0);
        list.addListener(c -> listHashProp.set(c.getList().hashCode()));
        OptionsBuilder options = new OptionsBuilder();
        if (this.includeDescription) {
            options.nameAndDescription(this.translationKey);
        } else {
            options.name(this.translationKey);
        }
        options.addComp((BaseRegionBuilder)new HostAddressChoiceComp((ObjectProperty<String>)val, (ObservableList<String>)list, this.allowMutation));
        options.addProperty((Property)val);
        options.nonNull();
        options.addProperty((Property)listHashProp);
        options.bind(() -> {
            ArrayList<String> fullList = new ArrayList<String>((Collection<String>)list);
            if (val.getValue() != null && !fullList.contains(val.getValue())) {
                fullList.add((String)val.getValue());
            }
            TrackEvent.withTrace((String)"Host address update").tag("address", val.getValue()).tag("list", fullList).handle();
            return HostAddress.of((String)((String)val.getValue()), fullList);
        }, new Property[]{this.value});
        return options;
    }

    @Generated
    HostAddressChoice(Property<HostAddress> value, boolean allowMutation, String translationKey, boolean includeDescription) {
        this.value = value;
        this.allowMutation = allowMutation;
        this.translationKey = translationKey;
        this.includeDescription = includeDescription;
    }

    @Generated
    public static HostAddressChoiceBuilder builder() {
        return new HostAddressChoiceBuilder();
    }

    @Generated
    public Property<HostAddress> getValue() {
        return this.value;
    }

    @Generated
    public boolean isAllowMutation() {
        return this.allowMutation;
    }

    @Generated
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Generated
    public boolean isIncludeDescription() {
        return this.includeDescription;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostAddressChoice)) {
            return false;
        }
        HostAddressChoice other = (HostAddressChoice)o;
        if (this.isAllowMutation() != other.isAllowMutation()) {
            return false;
        }
        if (this.isIncludeDescription() != other.isIncludeDescription()) {
            return false;
        }
        Property<HostAddress> this$value = this.getValue();
        Property<HostAddress> other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$translationKey = this.getTranslationKey();
        String other$translationKey = other.getTranslationKey();
        return !(this$translationKey == null ? other$translationKey != null : !this$translationKey.equals(other$translationKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowMutation() ? 79 : 97);
        result = result * 59 + (this.isIncludeDescription() ? 79 : 97);
        Property<HostAddress> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $translationKey = this.getTranslationKey();
        result = result * 59 + ($translationKey == null ? 43 : $translationKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostAddressChoice(value=" + String.valueOf(this.getValue()) + ", allowMutation=" + this.isAllowMutation() + ", translationKey=" + this.getTranslationKey() + ", includeDescription=" + this.isIncludeDescription() + ")";
    }

    @Generated
    public static class HostAddressChoiceBuilder {
        @Generated
        private Property<HostAddress> value;
        @Generated
        private boolean allowMutation;
        @Generated
        private String translationKey;
        @Generated
        private boolean includeDescription;

        @Generated
        HostAddressChoiceBuilder() {
        }

        @Generated
        public HostAddressChoiceBuilder value(Property<HostAddress> value) {
            this.value = value;
            return this;
        }

        @Generated
        public HostAddressChoiceBuilder allowMutation(boolean allowMutation) {
            this.allowMutation = allowMutation;
            return this;
        }

        @Generated
        public HostAddressChoiceBuilder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @Generated
        public HostAddressChoiceBuilder includeDescription(boolean includeDescription) {
            this.includeDescription = includeDescription;
            return this;
        }

        @Generated
        public HostAddressChoice build() {
            return new HostAddressChoice(this.value, this.allowMutation, this.translationKey, this.includeDescription);
        }

        @Generated
        public String toString() {
            return "HostAddressChoice.HostAddressChoiceBuilder(value=" + String.valueOf(this.value) + ", allowMutation=" + this.allowMutation + ", translationKey=" + this.translationKey + ", includeDescription=" + this.includeDescription + ")";
        }
    }
}

