/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.host;

import atlantafx.base.controls.Spacer;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.RegionBuilder;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.ComboTextFieldComp;
import io.xpipe.app.comp.base.IconButtonComp;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.platform.MenuHelper;
import java.util.ArrayList;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.javafx.FontIcon;

public class HostAddressChoiceComp
extends RegionBuilder<HBox> {
    private final ObjectProperty<String> currentAddress;
    private final ObservableList<String> allAddresses;
    private final boolean mutable;

    public HostAddressChoiceComp(ObjectProperty<String> currentAddress, ObservableList<String> allAddresses, boolean mutable) {
        this.currentAddress = currentAddress;
        this.allAddresses = allAddresses;
        this.mutable = mutable;
    }

    public HBox createSimple() {
        SimpleBooleanProperty adding = new SimpleBooleanProperty(false);
        BaseRegionBuilder<?, ?> combo = this.createComboBox((ObservableBooleanValue)adding);
        ButtonComp addButton = new ButtonComp(null, (Node)new FontIcon("mdi2f-format-list-group-plus"), () -> {
            String toAdd = (String)this.currentAddress.getValue();
            if (toAdd == null) {
                return;
            }
            adding.set(true);
            if (!this.allAddresses.contains((Object)toAdd)) {
                this.allAddresses.addFirst((Object)toAdd);
            }
            this.currentAddress.setValue(null);
            adding.set(false);
        });
        addButton.describe(d -> d.nameKey("addAnotherHostName"));
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(combo);
        if (this.mutable) {
            nodes.add(addButton);
        }
        InputGroupComp layout = new InputGroupComp(nodes);
        layout.setMainReference(combo);
        layout.apply(struc -> struc.setFillHeight(true));
        return (HBox)layout.build();
    }

    private BaseRegionBuilder<?, ?> createComboBox(ObservableBooleanValue adding) {
        SimpleStringProperty prop = new SimpleStringProperty();
        this.currentAddress.subscribe(hostAddress -> prop.setValue(hostAddress));
        prop.addListener((observable, oldValue, newValue) -> {
            if (this.mutable) {
                this.currentAddress.setValue(newValue);
                int index = this.allAddresses.indexOf(oldValue);
                if (!adding.get() && index != -1) {
                    Platform.runLater(() -> {
                        if (newValue != null) {
                            if (!this.allAddresses.contains(newValue)) {
                                this.allAddresses.set(index, newValue);
                            }
                        } else {
                            this.allAddresses.remove(index);
                        }
                    });
                }
            } else if (this.allAddresses.contains(newValue)) {
                this.currentAddress.setValue(newValue);
            }
        });
        ComboTextFieldComp combo = new ComboTextFieldComp((Property)prop, this.allAddresses, () -> new ListCell<String>(this){
            final /* synthetic */ HostAddressChoiceComp this$0;
            {
                HostAddressChoiceComp hostAddressChoiceComp = this$0;
                Objects.requireNonNull(hostAddressChoiceComp);
                this.this$0 = hostAddressChoiceComp;
                this.setOnMouseClicked(event -> {
                    this.getScene().getWindow().hide();
                    event.consume();
                });
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    return;
                }
                HBox hbox = new HBox();
                hbox.getChildren().add((Object)new Label(item));
                hbox.getChildren().add((Object)new Spacer());
                if (this.this$0.mutable) {
                    hbox.getChildren().add((Object)new IconButtonComp("mdi2t-trash-can-outline", () -> this.this$0.allAddresses.remove((Object)item)).build());
                }
                this.setGraphic((Node)hbox);
                this.setText(null);
            }
        });
        combo.apply(struc -> {
            ComboBoxListViewSkin skin = new ComboBoxListViewSkin(struc);
            MenuHelper.fixComboBoxSkin((ComboBoxListViewSkin)skin);
            struc.setSkin((Skin)skin);
            skin.setHideOnClick(false);
            ((SingleSelectionModel)struc.selectionModelProperty().get()).selectedIndexProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> struc.getParent().requestFocus()));
            this.allAddresses.addListener(change -> {
                struc.setVisibleRowCount(10);
                if (!change.next()) {
                    return;
                }
                if (change.wasReplaced()) {
                    return;
                }
                if (struc.isShowing()) {
                    struc.hide();
                    if (this.allAddresses.size() > 0) {
                        struc.show();
                    }
                } else {
                    struc.requestFocus();
                    if (this.allAddresses.size() > 0) {
                        struc.show();
                    }
                }
                struc.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"empty"), this.allAddresses.isEmpty());
            });
            struc.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"empty"), this.allAddresses.isEmpty());
            this.currentAddress.addListener((observable, oldValue, newValue) -> {
                if (newValue == null) {
                    struc.requestFocus();
                }
            });
        });
        combo.hgrow();
        combo.style(new String[]{"host-address-choice-comp"});
        return combo;
    }
}

