/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.browser.file.BrowserFileOpener;
import io.xpipe.app.browser.file.BrowserFileSystemTabModel;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.RegionBuilder;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.HorizontalComp;
import io.xpipe.app.comp.base.LabelComp;
import io.xpipe.app.comp.base.LoadingOverlayComp;
import io.xpipe.app.comp.base.ModalButton;
import io.xpipe.app.comp.base.ModalOverlay;
import io.xpipe.app.core.AppFontSizes;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FileEntry;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.PlatformThread;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BooleanScope;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.IdentitySummary;
import io.xpipe.ext.base.identity.IdentitySwitchStore;
import io.xpipe.ext.base.identity.IdentityValue;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import lombok.Generated;

public class IdentityApplyDialog {
    private static void addPublicKey(SystemState systemState, ShellControl sc, String publicKey) throws Exception {
        String text;
        ShellView v = sc.view();
        FilePath authorizedKeysFile = systemState.getAuthorizedKeysFile();
        v.mkdir(authorizedKeysFile.getParent());
        String authorizedKeysContent = v.fileExists(authorizedKeysFile) ? ((text = v.readTextFile(authorizedKeysFile).strip()).isBlank() ? publicKey + "\n" : text + "\n" + publicKey + "\n") : publicKey + "\n";
        v.writeTextFile(authorizedKeysFile, authorizedKeysContent);
        if (sc.getOsType() != OsType.WINDOWS) {
            sc.command(CommandBuilder.of().add(new String[]{"chmod", "600"}).addFile(authorizedKeysFile)).execute();
        }
    }

    private static BaseRegionBuilder<?, ?> success() {
        LabelGraphic.IconGraphic graphic = new LabelGraphic.IconGraphic("mdi2c-checkbox-marked-outline");
        return (BaseRegionBuilder)((RegionBuilder)new LabelComp(AppI18n.observable((String)"valid", (Object[])new Object[0]), (ObservableValue)new ReadOnlyObjectWrapper((Object)graphic)).style(new String[]{"success"})).apply(struc -> AppFontSizes.lg((Node)struc));
    }

    private static BaseRegionBuilder<?, ?> warning() {
        LabelGraphic.IconGraphic graphic = new LabelGraphic.IconGraphic("mdi2a-alert-box-outline");
        return (BaseRegionBuilder)((RegionBuilder)new LabelComp(AppI18n.observable((String)"warning", (Object[])new Object[0]), (ObservableValue)new ReadOnlyObjectWrapper((Object)graphic)).style(new String[]{"warning"})).apply(struc -> AppFontSizes.lg((Node)struc));
    }

    private static BaseRegionBuilder<?, ?> fail(BaseRegionBuilder<?, ?> fixComp) {
        LabelGraphic.IconGraphic graphic = new LabelGraphic.IconGraphic("mdi2c-close-box-outline");
        RegionBuilder label = (RegionBuilder)new LabelComp(AppI18n.observable((String)"notValid", (Object[])new Object[0]), (ObservableValue)new ReadOnlyObjectWrapper((Object)graphic)).style(new String[]{"danger"});
        label.apply(struc -> AppFontSizes.lg((Node)struc));
        if (fixComp != null) {
            HorizontalComp hbox = new HorizontalComp(List.of(label, fixComp, RegionBuilder.hspacer()));
            hbox.spacing(10.0);
            return hbox;
        }
        return label;
    }

    private static BaseRegionBuilder<?, ?> createAuthorizedKeysOptions(Property<DataStoreEntryRef<ShellStore>> system, ObjectProperty<SystemState> systemState, IdentityStore identity, BooleanProperty busy) {
        BooleanBinding showAddAuthorizedHost = BindingsHelper.mapBoolean(systemState, s -> s != null && !s.isInAuthorizedKeys());
        RegionBuilder editButton = (RegionBuilder)new ButtonComp(AppI18n.observable((String)"identityApplyEditAuthorizedKeysButton", (Object[])new Object[0]), () -> ThreadHelper.runFailableAsync(() -> BooleanScope.executeExclusive((BooleanProperty)busy, () -> {
            ShellControl sc = ((ShellStore)((DataStoreEntryRef)system.getValue()).getStore()).getOrStartSession();
            FilePath file = ((SystemState)systemState.get()).getAuthorizedKeysFile();
            BrowserFileSystemTabModel model = BrowserFullSessionModel.DEFAULT.openFileSystemSync((DataStoreEntryRef)system.getValue(), null, m -> file.getParent(), null, false);
            Optional found = model.findFile(file);
            if (found.isEmpty()) {
                model.getFileSystem().touch(file);
                if (sc.getOsType() != OsType.WINDOWS) {
                    sc.command(CommandBuilder.of().add(new String[]{"chmod", "600"}).addFile(file)).execute();
                }
                model.refreshSync();
                found = model.findFile(file);
            }
            if (found.isPresent()) {
                BrowserFileOpener.openInTextEditor((BrowserFileSystemTabModel)model, (FileEntry)((FileEntry)found.get()));
            }
        }))).padding(new Insets(4.0, 8.0, 4.0, 8.0));
        RegionBuilder addButton = (RegionBuilder)new ButtonComp(AppI18n.observable((String)"identityApplyAuthorizedHostButton", (Object[])new Object[0]), () -> ThreadHelper.runFailableAsync(() -> BooleanScope.executeExclusive((BooleanProperty)busy, () -> {
            ShellControl sc = ((ShellStore)((DataStoreEntryRef)system.getValue()).getStore()).getOrStartSession();
            IdentityApplyDialog.addPublicKey((SystemState)systemState.get(), sc, identity.getSshIdentity().getPublicKey());
            systemState.setValue((Object)SystemState.of(sc, identity));
        }))).padding(new Insets(4.0, 8.0, 4.0, 8.0));
        OptionsBuilder options = new OptionsBuilder().nameAndDescription("identityApplyAuthorizedHost").addComp(IdentityApplyDialog.success()).hide((ObservableValue)showAddAuthorizedHost).nameAndDescription("identityApplyAuthorizedHost").addComp(IdentityApplyDialog.fail(addButton)).hide((ObservableValue)showAddAuthorizedHost.not()).nameAndDescription("identityApplyEditAuthorizedKeys").addComp((BaseRegionBuilder)editButton);
        return options.buildComp().hide((ObservableValue)Bindings.isNull(systemState));
    }

    private static BaseRegionBuilder<?, ?> createConfigOptions(Property<DataStoreEntryRef<ShellStore>> system, Property<SystemState> systemState, IdentityStore identity, BooleanProperty busy) {
        BooleanBinding showAdminWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && identity.getSshIdentity() != null && identity.getSshIdentity().providesKey() && s.isMightRequireAdministratorAuthorizedKeys());
        BooleanBinding showPasswordEnabledWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && (identity.getPassword() == null || !identity.getPassword().expectsQuery()) && s.isPasswordAuthEnabled() && s.isPasswordAuthInMethods());
        BooleanBinding showPasswordDisabledWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && identity.getPassword() != null && identity.getPassword().expectsQuery() && (!s.isPasswordAuthEnabled() || !s.isPasswordAuthInMethods()));
        BooleanBinding showKeyEnabledWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && (identity.getSshIdentity() == null || !identity.getSshIdentity().providesKey()) && s.keyAuthEnabled);
        BooleanBinding showKeyDisabledWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && identity.getSshIdentity() != null && identity.getSshIdentity().providesKey() && !s.keyAuthEnabled);
        BooleanBinding showRootDisabledWarning = BindingsHelper.mapBoolean(systemState, s -> s != null && identity.getUsername().getFixedUsername().map(u -> u.equals("root")).orElse(false) != false && !s.rootLoginEnabled);
        BooleanBinding showConfigSection = showKeyEnabledWarning.or((ObservableBooleanValue)showRootDisabledWarning).or((ObservableBooleanValue)showPasswordEnabledWarning).or((ObservableBooleanValue)showPasswordDisabledWarning).or((ObservableBooleanValue)showKeyDisabledWarning).or((ObservableBooleanValue)showAdminWarning);
        RegionBuilder editButton = (RegionBuilder)new ButtonComp(AppI18n.observable((String)"identityApplyEditConfigButton", (Object[])new Object[0]), () -> ThreadHelper.runFailableAsync(() -> BooleanScope.executeExclusive((BooleanProperty)busy, () -> {
            FilePath file = ((SystemState)systemState.getValue()).getConfigFile();
            BrowserFileSystemTabModel model = BrowserFullSessionModel.DEFAULT.openFileSystemSync((DataStoreEntryRef)system.getValue(), null, m -> file.getParent(), null, false);
            Optional found = model.findFile(file);
            if (found.isEmpty()) {
                return;
            }
            BrowserFileOpener.openInTextEditor((BrowserFileSystemTabModel)model, (FileEntry)((FileEntry)found.get()));
        }))).padding(new Insets(4.0, 8.0, 4.0, 8.0));
        RegionBuilder options = (RegionBuilder)new OptionsBuilder().nameAndDescription("identityApplyConfigPasswordEnabled").addComp(IdentityApplyDialog.warning()).hide((ObservableValue)showPasswordEnabledWarning.not()).nameAndDescription("identityApplyConfigPasswordDisabled").addComp(IdentityApplyDialog.warning()).hide((ObservableValue)showPasswordDisabledWarning.not()).nameAndDescription("identityApplyConfigKeyEnabled").addComp(IdentityApplyDialog.warning()).hide((ObservableValue)showKeyEnabledWarning.not()).nameAndDescription("identityApplyConfigKeyDisabled").addComp(IdentityApplyDialog.warning()).hide((ObservableValue)showKeyDisabledWarning.not()).nameAndDescription("identityApplyConfigRootDisabledWarning").addComp(IdentityApplyDialog.fail(null)).hide((ObservableValue)showRootDisabledWarning.not()).nameAndDescription("identityApplyConfigAdminWarning").documentationLink("https://learn.microsoft.com/en-us/windows-server/administration/openssh/openssh_keymanagement#administrative-user").addComp(IdentityApplyDialog.warning()).hide((ObservableValue)showAdminWarning.not()).nameAndDescription("identityApplyEditConfig").addComp((BaseRegionBuilder)editButton).buildComp().hide((ObservableValue)showConfigSection.not());
        return options;
    }

    public static void show(final DataStoreEntryRef<IdentityStore> identity) {
        SimpleBooleanProperty busy = new SimpleBooleanProperty();
        SimpleObjectProperty system = new SimpleObjectProperty();
        SimpleObjectProperty systemState = new SimpleObjectProperty();
        SimpleBooleanProperty showSetIdentityButton = new SimpleBooleanProperty();
        SimpleBooleanProperty showIdentityAlreadySet = new SimpleBooleanProperty();
        system.addListener((observable, oldValue, newValue) -> {
            systemState.setValue(null);
            showSetIdentityButton.set(false);
            showIdentityAlreadySet.set(false);
            if (newValue == null) {
                return;
            }
            ThreadHelper.runFailableAsync(() -> BooleanScope.executeExclusive((BooleanProperty)busy, () -> {
                IdentitySwitchStore iss;
                ShellControl sc = ((ShellStore)newValue.getStore()).getOrStartSession();
                systemState.setValue((Object)SystemState.of(sc, (IdentityStore)identity.getStore()));
                DataStore patt0$temp = newValue.getStore();
                showSetIdentityButton.set(patt0$temp instanceof IdentitySwitchStore && !(iss = (IdentitySwitchStore)patt0$temp).getIdentity().unwrap().equals(identity.getStore()));
                DataStore patt1$temp = newValue.getStore();
                showIdentityAlreadySet.set(patt1$temp instanceof IdentitySwitchStore && (iss = (IdentitySwitchStore)patt1$temp).getIdentity().unwrap().equals(identity.getStore()));
            }));
        });
        StoreChoiceComp<ShellStore> systemChoice = new StoreChoiceComp<ShellStore>(null, (ObjectProperty)system, ShellStore.class, null, StoreViewState.get().getAllConnectionsCategory()){

            protected String toName(DataStoreEntry entry) {
                if (entry == null) {
                    return null;
                }
                return DataStorage.get().getStoreEntryDisplayName(entry) + " -> " + IdentitySummary.createSummary((IdentityStore)identity.getStore());
            }
        };
        LoadingOverlayComp systemChoiceBusy = new LoadingOverlayComp((BaseRegionBuilder)systemChoice, (ObservableValue)busy, false);
        ButtonComp applyButton = new ButtonComp(AppI18n.observable((String)"identityApplySetStoreIdentityButton", (Object[])new Object[0]), () -> {
            DataStorage.get().updateEntryStore(((DataStoreEntryRef)system.get()).get(), (DataStore)((IdentitySwitchStore)((DataStoreEntryRef)system.get()).getStore()).withIdentity(new IdentityValue.Ref(identity)));
            showSetIdentityButton.set(false);
            showIdentityAlreadySet.set(true);
        });
        applyButton.padding(new Insets(4.0, 8.0, 4.0, 8.0));
        OptionsBuilder options = new OptionsBuilder().nameAndDescription("identityApplyTargetHost").documentationLink(DocumentationLink.IDENTITY_APPLY).addComp((BaseRegionBuilder)systemChoiceBusy, (Property)system).addComp(IdentityApplyDialog.createAuthorizedKeysOptions((Property<DataStoreEntryRef<ShellStore>>)system, (ObjectProperty<SystemState>)systemState, (IdentityStore)identity.getStore(), (BooleanProperty)busy)).addComp(IdentityApplyDialog.createConfigOptions((Property<DataStoreEntryRef<ShellStore>>)system, (Property<SystemState>)systemState, (IdentityStore)identity.getStore(), (BooleanProperty)busy)).nameAndDescription("identityApplySetStoreIdentity").addComp(IdentityApplyDialog.success()).hide((ObservableValue)showIdentityAlreadySet.not()).nameAndDescription("identityApplySetStoreIdentity").addComp(IdentityApplyDialog.fail(applyButton)).hide((ObservableValue)showSetIdentityButton.not());
        ModalOverlay modal = ModalOverlay.of((String)"identityApplyTitle", (BaseRegionBuilder)((BaseRegionBuilder)((RegionBuilder)options.buildComp().prefWidth(600.0)).prefHeight(500.0)));
        modal.persist();
        modal.addButton(ModalButton.cancel());
        modal.addButton(ModalButton.ok().augment(button -> button.disableProperty().bind(PlatformThread.sync((ObservableValue)busy))));
        modal.show();
    }

    private static class SystemState {
        boolean inAuthorizedKeys;
        boolean keyAuthEnabled;
        boolean keyAuthInMethods;
        boolean passwordAuthEnabled;
        boolean passwordAuthInMethods;
        boolean rootLoginEnabled;
        boolean mightRequireAdministratorAuthorizedKeys;
        FilePath configFile;
        FilePath authorizedKeysFile;

        public static SystemState of(ShellControl sc, IdentityStore identity) throws Exception {
            SystemState s = new SystemState();
            s.init(sc, identity);
            return s;
        }

        private void init(ShellControl sc, IdentityStore identity) throws Exception {
            boolean hasPassword = identity.getPassword() != null && identity.getPassword().expectsQuery();
            boolean hasIdentity = identity.getSshIdentity() != null && identity.getSshIdentity().getPublicKey() != null;
            this.configFile = this.getSystemConfigPath(sc);
            this.authorizedKeysFile = this.getAuthorizedKeysFile(sc);
            String configContent = this.getSshdConfigContent(sc);
            this.keyAuthEnabled = this.isSet(configContent, "PubkeyAuthentication", "yes", true, false);
            this.passwordAuthEnabled = this.isSet(configContent, "PasswordAuthentication", "yes", true, false);
            this.rootLoginEnabled = this.isSet(configContent, "PermitRootLogin", "yes", !hasPassword, false) || !hasPassword && !this.isSet(configContent, "PermitRootLogin", "forced-commands-only", true, false) && this.isSet(configContent, "PermitRootLogin", "prohibit-password", true, true);
            this.keyAuthInMethods = this.isSet(configContent, "AuthenticationMethods", "publickey", true, false);
            this.passwordAuthInMethods = this.isSet(configContent, "AuthenticationMethods", "password", true, false);
            boolean bl = this.mightRequireAdministratorAuthorizedKeys = sc.getOsType() == OsType.WINDOWS && this.isSet(configContent, "Match", "Group administrators", false, false) && this.isSet(configContent, "AuthorizedKeysFile", "administrators_authorized_keys", false, false);
            if (hasIdentity) {
                String authorizedKeysContent = this.getAuthorizedKeysContent(sc);
                String publicKey = identity.getSshIdentity().getPublicKey();
                String[] split = publicKey.split("\\s+");
                String basePublicKey = split[0] + " " + split[1];
                this.inAuthorizedKeys = authorizedKeysContent.toLowerCase().contains(basePublicKey.toLowerCase());
            } else {
                this.inAuthorizedKeys = true;
            }
        }

        private FilePath getSystemConfigPath(ShellControl sc) throws Exception {
            if (sc.getOsType() == OsType.WINDOWS) {
                String base = sc.view().getEnvironmentVariableOrThrow("programdata");
                return FilePath.of((String)base).join(new String[]{"ssh", "sshd_config"});
            }
            return FilePath.of((String)"/etc/ssh/sshd_config");
        }

        private FilePath getAuthorizedKeysFile(ShellControl sc) throws Exception {
            ShellView v = sc.view();
            FilePath authorizedKeysFile = v.userHome().join(new String[]{".ssh", "authorized_keys"});
            return authorizedKeysFile;
        }

        private String getAuthorizedKeysContent(ShellControl sc) throws Exception {
            ShellView v = sc.view();
            String authorizedKeysContent = v.fileExists(this.authorizedKeysFile) ? v.readTextFile(this.authorizedKeysFile) : "";
            return authorizedKeysContent;
        }

        private String getSshdConfigContent(ShellControl sc) throws Exception {
            ShellView v = sc.view();
            String configContent = v.fileExists(this.configFile) ? v.readTextFile(this.configFile) : "";
            return configContent;
        }

        private boolean isSet(String config, String name, String value, boolean notFoundDef, boolean notSpecifiedDef) {
            List<String> found = config.lines().filter(s -> !s.strip().startsWith("#")).filter(s -> s.toLowerCase().contains(name.toLowerCase())).toList();
            if (found.isEmpty()) {
                return notFoundDef;
            }
            for (String line : found) {
                boolean matches = line.toLowerCase().contains(value.toLowerCase());
                if (!matches) continue;
                return true;
            }
            return notSpecifiedDef;
        }

        @Generated
        public SystemState() {
        }

        @Generated
        public boolean isInAuthorizedKeys() {
            return this.inAuthorizedKeys;
        }

        @Generated
        public boolean isKeyAuthEnabled() {
            return this.keyAuthEnabled;
        }

        @Generated
        public boolean isKeyAuthInMethods() {
            return this.keyAuthInMethods;
        }

        @Generated
        public boolean isPasswordAuthEnabled() {
            return this.passwordAuthEnabled;
        }

        @Generated
        public boolean isPasswordAuthInMethods() {
            return this.passwordAuthInMethods;
        }

        @Generated
        public boolean isRootLoginEnabled() {
            return this.rootLoginEnabled;
        }

        @Generated
        public boolean isMightRequireAdministratorAuthorizedKeys() {
            return this.mightRequireAdministratorAuthorizedKeys;
        }

        @Generated
        public FilePath getConfigFile() {
            return this.configFile;
        }

        @Generated
        public FilePath getAuthorizedKeysFile() {
            return this.authorizedKeysFile;
        }

        @Generated
        public void setInAuthorizedKeys(boolean inAuthorizedKeys) {
            this.inAuthorizedKeys = inAuthorizedKeys;
        }

        @Generated
        public void setKeyAuthEnabled(boolean keyAuthEnabled) {
            this.keyAuthEnabled = keyAuthEnabled;
        }

        @Generated
        public void setKeyAuthInMethods(boolean keyAuthInMethods) {
            this.keyAuthInMethods = keyAuthInMethods;
        }

        @Generated
        public void setPasswordAuthEnabled(boolean passwordAuthEnabled) {
            this.passwordAuthEnabled = passwordAuthEnabled;
        }

        @Generated
        public void setPasswordAuthInMethods(boolean passwordAuthInMethods) {
            this.passwordAuthInMethods = passwordAuthInMethods;
        }

        @Generated
        public void setRootLoginEnabled(boolean rootLoginEnabled) {
            this.rootLoginEnabled = rootLoginEnabled;
        }

        @Generated
        public void setMightRequireAdministratorAuthorizedKeys(boolean mightRequireAdministratorAuthorizedKeys) {
            this.mightRequireAdministratorAuthorizedKeys = mightRequireAdministratorAuthorizedKeys;
        }

        @Generated
        public void setConfigFile(FilePath configFile) {
            this.configFile = configFile;
        }

        @Generated
        public void setAuthorizedKeysFile(FilePath authorizedKeysFile) {
            this.authorizedKeysFile = authorizedKeysFile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemState)) {
                return false;
            }
            SystemState other = (SystemState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isInAuthorizedKeys() != other.isInAuthorizedKeys()) {
                return false;
            }
            if (this.isKeyAuthEnabled() != other.isKeyAuthEnabled()) {
                return false;
            }
            if (this.isKeyAuthInMethods() != other.isKeyAuthInMethods()) {
                return false;
            }
            if (this.isPasswordAuthEnabled() != other.isPasswordAuthEnabled()) {
                return false;
            }
            if (this.isPasswordAuthInMethods() != other.isPasswordAuthInMethods()) {
                return false;
            }
            if (this.isRootLoginEnabled() != other.isRootLoginEnabled()) {
                return false;
            }
            if (this.isMightRequireAdministratorAuthorizedKeys() != other.isMightRequireAdministratorAuthorizedKeys()) {
                return false;
            }
            FilePath this$configFile = this.getConfigFile();
            FilePath other$configFile = other.getConfigFile();
            if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
                return false;
            }
            FilePath this$authorizedKeysFile = this.getAuthorizedKeysFile();
            FilePath other$authorizedKeysFile = other.getAuthorizedKeysFile();
            return !(this$authorizedKeysFile == null ? other$authorizedKeysFile != null : !this$authorizedKeysFile.equals(other$authorizedKeysFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SystemState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInAuthorizedKeys() ? 79 : 97);
            result = result * 59 + (this.isKeyAuthEnabled() ? 79 : 97);
            result = result * 59 + (this.isKeyAuthInMethods() ? 79 : 97);
            result = result * 59 + (this.isPasswordAuthEnabled() ? 79 : 97);
            result = result * 59 + (this.isPasswordAuthInMethods() ? 79 : 97);
            result = result * 59 + (this.isRootLoginEnabled() ? 79 : 97);
            result = result * 59 + (this.isMightRequireAdministratorAuthorizedKeys() ? 79 : 97);
            FilePath $configFile = this.getConfigFile();
            result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
            FilePath $authorizedKeysFile = this.getAuthorizedKeysFile();
            result = result * 59 + ($authorizedKeysFile == null ? 43 : $authorizedKeysFile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IdentityApplyDialog.SystemState(inAuthorizedKeys=" + this.isInAuthorizedKeys() + ", keyAuthEnabled=" + this.isKeyAuthEnabled() + ", keyAuthInMethods=" + this.isKeyAuthInMethods() + ", passwordAuthEnabled=" + this.isPasswordAuthEnabled() + ", passwordAuthInMethods=" + this.isPasswordAuthInMethods() + ", rootLoginEnabled=" + this.isRootLoginEnabled() + ", mightRequireAdministratorAuthorizedKeys=" + this.isMightRequireAdministratorAuthorizedKeys() + ", configFile=" + String.valueOf(this.getConfigFile()) + ", authorizedKeysFile=" + String.valueOf(this.getAuthorizedKeysFile()) + ")";
        }
    }
}

