/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.window.AppDialog;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.hub.comp.StoreCreationDialog;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.identity.IdentityApplyDialog;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public class IdentityApplyHubLeafProvider
implements HubLeafProvider<IdentityStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.OPEN;
    }

    public boolean isMajor() {
        return true;
    }

    public boolean isApplicable(DataStoreEntryRef<IdentityStore> o) {
        DataStoreState state = o.get().getStorePersistentState();
        if (state instanceof SystemState) {
            SystemState systemState = (SystemState)state;
            return !(systemState.getShellDialect() != null && !systemState.getShellDialect().getDumbMode().supportsAnyPossibleInteraction() || systemState.getTtyState() != null && systemState.getTtyState() != ShellTtyState.NONE);
        }
        return true;
    }

    public ObservableValue<String> getName(DataStoreEntryRef<IdentityStore> store) {
        return AppI18n.observable((String)"applyIdentityToHost", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<IdentityStore> store) {
        return new LabelGraphic.IconGraphic("mdi2e-export");
    }

    public Class<?> getApplicableClass() {
        return IdentityStore.class;
    }

    public AbstractAction createAction(DataStoreEntryRef<IdentityStore> ref) {
        return ((Action.ActionBuilder)Action.builder().ref(ref)).build();
    }

    public String getId() {
        return "applyIdentity";
    }

    @JsonDeserialize(builder=ActionBuilderImpl.class)
    public static class Action
    extends StoreAction<IdentityStore> {
        public void executeImpl() {
            if (((IdentityStore)this.ref.getStore()).getSshIdentity() != null && !(((IdentityStore)this.ref.getStore()).getSshIdentity() instanceof NoIdentityStrategy) && ((IdentityStore)this.ref.getStore()).getSshIdentity().getPublicKey() == null) {
                AppDialog.confirm((String)"identityApplyMissingPublicKey");
                StoreCreationDialog.showEdit((DataStoreEntry)this.ref.get());
                return;
            }
            IdentityApplyDialog.show((DataStoreEntryRef<IdentityStore>)this.ref);
        }

        @Generated
        protected Action(ActionBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ActionBuilder<?, ?> builder() {
            return new ActionBuilderImpl();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ActionBuilderImpl
        extends ActionBuilder<Action, ActionBuilderImpl> {
            @Generated
            private ActionBuilderImpl() {
            }

            @Override
            @Generated
            protected ActionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Action build() {
                return new Action(this);
            }
        }

        @Generated
        public static abstract class ActionBuilder<C extends Action, B extends ActionBuilder<C, B>>
        extends StoreAction.StoreActionBuilder<IdentityStore, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "IdentityApplyHubLeafProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

