/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.RegionBuilder;
import io.xpipe.app.comp.base.AnchorComp;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.ComboTextFieldComp;
import io.xpipe.app.comp.base.IconButtonComp;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.comp.base.PrettyImageHelper;
import io.xpipe.app.core.AppFontSizes;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.hub.comp.StoreChoicePopover;
import io.xpipe.app.hub.comp.StoreCreationDialog;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.MenuHelper;
import io.xpipe.app.platform.PlatformThread;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.PasswordManagerIdentityStore;
import io.xpipe.ext.base.identity.SyncedIdentityStore;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

public class IdentitySelectComp
extends RegionBuilder<HBox> {
    private final ObjectProperty<DataStoreEntryRef<IdentityStore>> selectedReference;
    private final Property<String> inPlaceUser;
    private final ObservableValue<SecretRetrievalStrategy> password;
    private final ObservableValue<SshIdentityStrategy> identityStrategy;
    private final boolean allowUserInput;

    public IdentitySelectComp(ObjectProperty<DataStoreEntryRef<IdentityStore>> selectedReference, Property<String> inPlaceUser, ObservableValue<SecretRetrievalStrategy> password, ObservableValue<SshIdentityStrategy> identityStrategy, boolean allowUserInput) {
        this.selectedReference = selectedReference;
        this.inPlaceUser = inPlaceUser;
        this.password = password;
        this.identityStrategy = identityStrategy;
        this.allowUserInput = allowUserInput;
    }

    private void addNamedIdentity() {
        EncryptedValue.CurrentKey ssh;
        boolean hasSshIdentity;
        boolean hasPwMan = AppPrefs.get().passwordManager().getValue() != null;
        Optional<PasswordManagerIdentityStore> pwManIdentity = DataStorage.get().getStoreEntries().stream().map(entry -> {
            PasswordManagerIdentityStore p;
            DataStore patt0$temp = entry.getStore();
            return patt0$temp instanceof PasswordManagerIdentityStore ? (p = (PasswordManagerIdentityStore)patt0$temp) : null;
        }).filter(s -> s != null).findFirst();
        boolean hasPassword = this.password.getValue() != null && !(this.password.getValue() instanceof SecretNoneStrategy);
        boolean bl = hasSshIdentity = this.identityStrategy.getValue() != null && !(this.identityStrategy.getValue() instanceof NoIdentityStrategy);
        if (hasPwMan && pwManIdentity.isPresent() && !hasPassword && !hasSshIdentity) {
            boolean perUser = pwManIdentity.get().isPerUser();
            IdentityStore id = ((PasswordManagerIdentityStore.PasswordManagerIdentityStoreBuilder)((PasswordManagerIdentityStore.PasswordManagerIdentityStoreBuilder)PasswordManagerIdentityStore.builder().key((String)this.inPlaceUser.getValue())).perUser(perUser)).build();
            this.showIdentityCreation(id);
            return;
        }
        Optional<SyncedIdentityStore> synced = DataStorage.get().getStoreEntries().stream().map(entry -> {
            SyncedIdentityStore p;
            DataStore patt0$temp = entry.getStore();
            return patt0$temp instanceof SyncedIdentityStore ? (p = (SyncedIdentityStore)patt0$temp) : null;
        }).filter(s -> s != null).findFirst();
        if (synced.isPresent()) {
            EncryptedValue.VaultKey ssh2;
            EncryptedValue.VaultKey pass = EncryptedValue.VaultKey.of((Object)((SecretRetrievalStrategy)this.password.getValue()));
            if (pass == null) {
                pass = EncryptedValue.VaultKey.of((Object)new SecretNoneStrategy());
            }
            if ((ssh2 = EncryptedValue.VaultKey.of((Object)((SshIdentityStrategy)this.identityStrategy.getValue()))) == null) {
                ssh2 = EncryptedValue.VaultKey.of((Object)new NoIdentityStrategy());
            }
            IdentityStore id = ((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)SyncedIdentityStore.builder().username((String)this.inPlaceUser.getValue())).password((EncryptedValue.VaultKey<SecretRetrievalStrategy>)pass)).sshIdentity((EncryptedValue.VaultKey<SshIdentityStrategy>)ssh2)).build();
            this.showIdentityCreation(id);
            return;
        }
        EncryptedValue.CurrentKey pass = EncryptedValue.CurrentKey.of((Object)((SecretRetrievalStrategy)this.password.getValue()));
        if (pass == null) {
            pass = EncryptedValue.CurrentKey.of((Object)new SecretNoneStrategy());
        }
        if ((ssh = EncryptedValue.CurrentKey.of((Object)((SshIdentityStrategy)this.identityStrategy.getValue()))) == null) {
            ssh = EncryptedValue.CurrentKey.of((Object)new NoIdentityStrategy());
        }
        IdentityStore id = ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username((String)this.inPlaceUser.getValue())).password((EncryptedValue<SecretRetrievalStrategy>)pass)).sshIdentity((EncryptedValue<SshIdentityStrategy>)ssh)).build();
        this.showIdentityCreation(id);
    }

    private void showIdentityCreation(IdentityStore store) {
        StoreCreationDialog.showCreation(null, (DataStore)store, (DataStoreCreationCategory)DataStoreCreationCategory.IDENTITY, dataStoreEntry -> PlatformThread.runLaterIfNeeded(() -> this.applyRef((DataStoreEntryRef<IdentityStore>)dataStoreEntry.ref())), (boolean)false);
    }

    private void editNamedIdentity() {
        DataStoreEntryRef id = (DataStoreEntryRef)this.selectedReference.get();
        if (id == null) {
            return;
        }
        StoreCreationDialog.showEdit((DataStoreEntry)id.get());
    }

    public HBox createSimple() {
        ObjectBinding icon = Bindings.createObjectBinding(() -> this.selectedReference.get() != null ? new LabelGraphic.IconGraphic("mdi2a-account-edit") : new LabelGraphic.IconGraphic("mdi2a-account-multiple-plus"), (Observable[])new Observable[]{this.selectedReference});
        ButtonComp addButton = new ButtonComp(null, (ObservableValue)icon, () -> {
            if (this.selectedReference.get() != null) {
                this.editNamedIdentity();
            } else {
                this.addNamedIdentity();
            }
        });
        addButton.describe(d -> d.nameKey("addReusableIdentity"));
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(this.createComboBox());
        nodes.add(addButton);
        RegionBuilder layout = (RegionBuilder)new InputGroupComp(nodes).setMainReference(0).apply(struc -> struc.setFillHeight(true));
        layout.apply(struc -> struc.focusedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> ((Node)struc.getChildren().getFirst()).requestFocus())));
        return (HBox)layout.build();
    }

    private String formatName(DataStoreEntry storeEntry) {
        IdentityStore id = (IdentityStore)storeEntry.getStore().asNeeded();
        String suffix = id instanceof LocalIdentityStore ? AppI18n.get((String)"localIdentity", (Object[])new Object[0]) : (id instanceof PasswordManagerIdentityStore ? AppI18n.get((String)"passwordManagerIdentity", (Object[])new Object[0]) : (id instanceof SyncedIdentityStore && storeEntry.isPerUserStore() ? AppI18n.get((String)"userIdentity", (Object[])new Object[0]) : AppI18n.get((String)"globalIdentity", (Object[])new Object[0])));
        return storeEntry.getName() + " (" + suffix + ")";
    }

    private void applyRef(DataStoreEntryRef<IdentityStore> newRef) {
        this.selectedReference.setValue(newRef);
    }

    private BaseRegionBuilder<?, ?> createComboBox() {
        final LinkedHashMap<String, DataStoreEntryRef> map = new LinkedHashMap<String, DataStoreEntryRef>();
        for (DataStoreEntry storeEntry : DataStorage.get().getStoreEntries()) {
            if (!storeEntry.getValidity().isUsable() || !(storeEntry.getStore() instanceof IdentityStore)) continue;
            map.put(this.formatName(storeEntry), storeEntry.ref());
        }
        StoreViewState.get().getAllEntries().getList().addListener(c -> {
            map.clear();
            for (DataStoreEntry storeEntry : DataStorage.get().getStoreEntries()) {
                if (!storeEntry.getValidity().isUsable() || !(storeEntry.getStore() instanceof IdentityStore)) continue;
                map.put(this.formatName(storeEntry), storeEntry.ref());
            }
        });
        SimpleStringProperty prop = new SimpleStringProperty();
        if (this.inPlaceUser.getValue() != null) {
            prop.setValue((String)this.inPlaceUser.getValue());
        } else if (this.selectedReference.getValue() != null) {
            prop.setValue(this.formatName(((DataStoreEntryRef)this.selectedReference.getValue()).get()));
        }
        prop.addListener((observable, oldValue, newValue) -> {
            DataStoreEntryRef ex = (DataStoreEntryRef)map.get(newValue);
            this.applyRef((DataStoreEntryRef<IdentityStore>)ex);
            if (ex == null) {
                this.inPlaceUser.setValue(newValue);
            } else {
                this.inPlaceUser.setValue(null);
            }
        });
        this.selectedReference.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                PlatformThread.runLaterIfNeeded(() -> {
                    String s = this.formatName(newValue.get());
                    prop.setValue(s);
                });
            } else {
                prop.setValue(null);
            }
        });
        ComboTextFieldComp combo = new ComboTextFieldComp((Property)prop, FXCollections.observableList(map.keySet().stream().toList()), () -> new ListCell<String>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    return;
                }
                this.setText(item);
                if (item != null) {
                    DataStoreEntryRef store = (DataStoreEntryRef)map.get(item);
                    if (store != null) {
                        DataStoreProvider provider = store.get().getProvider();
                        String image = provider.getDisplayIconFileName(store.getStore());
                        this.setGraphic(PrettyImageHelper.ofFixedSize((String)image, (int)16, (int)16).build());
                    }
                } else {
                    this.setGraphic(null);
                }
            }
        });
        combo.apply(struc -> struc.setEditable(this.allowUserInput));
        combo.style(new String[]{"left-pill"});
        combo.apply(struc -> {
            StringBinding binding = Bindings.createStringBinding(() -> {
                if (this.selectedReference.get() != null) {
                    return ((DataStoreEntryRef)this.selectedReference.get()).get().getName();
                }
                return AppI18n.get((String)"defineNewIdentityOrSelect", (Object[])new Object[0]);
            }, (Observable[])new Observable[]{AppI18n.activeLanguage(), this.selectedReference});
            struc.promptTextProperty().bind((ObservableValue)binding);
        });
        combo.apply(struc -> struc.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE && !this.allowUserInput) {
                this.selectedReference.setValue(null);
                prop.setValue(null);
                event.consume();
            }
        }));
        combo.apply(struc -> {
            final StoreChoicePopover popover = new StoreChoicePopover(null, this.selectedReference, IdentityStore.class, null, StoreViewState.get().getAllIdentitiesCategory(), null, true, "selectIdentity", "noCompatibleIdentity");
            popover.withPopover(po -> {
                ((Region)po.getContentNode()).setMaxHeight(350.0);
                po.showingProperty().addListener((o, oldValue, newValue) -> {
                    if (!newValue.booleanValue()) {
                        struc.hide();
                    }
                });
            });
            ComboBoxListViewSkin<String> skin = new ComboBoxListViewSkin<String>(this, struc){
                {
                    Objects.requireNonNull(this$0);
                    super(arg0);
                }

                public void show() {
                    popover.show((Node)struc);
                }

                public void hide() {
                    popover.hide();
                }
            };
            MenuHelper.fixComboBoxSkin((ComboBoxListViewSkin)skin);
            struc.setSkin((Skin)skin);
        });
        combo.apply(struc -> struc.getEditor().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.selectedReference.get() != null) {
                Platform.runLater(() -> {
                    if (struc.isShowing()) {
                        return;
                    }
                    struc.getEditor().selectAll();
                });
            }
        }));
        IconButtonComp clearButton = new IconButtonComp("mdi2c-close", () -> {
            this.selectedReference.setValue(null);
            this.inPlaceUser.setValue(null);
        });
        clearButton.style(new String[]{"flat"});
        clearButton.hide((ObservableValue)this.selectedReference.isNull());
        clearButton.apply(struc -> {
            struc.setOpacity(0.7);
            struc.getStyleClass().add((Object)"clear-button");
            AppFontSizes.xs((Node)struc);
            AnchorPane.setRightAnchor((Node)struc, (Double)30.0);
            AnchorPane.setTopAnchor((Node)struc, (Double)3.0);
            AnchorPane.setBottomAnchor((Node)struc, (Double)3.0);
        });
        AnchorComp stack = new AnchorComp(List.of(combo, clearButton));
        stack.style(new String[]{"identity-select-comp"});
        stack.hgrow();
        stack.apply(struc -> {
            Region comboRegion = (Region)struc.getChildren().getFirst();
            struc.prefWidthProperty().bind((ObservableValue)comboRegion.prefWidthProperty());
            struc.prefHeightProperty().bind((ObservableValue)comboRegion.prefHeightProperty());
            AnchorPane.setLeftAnchor((Node)comboRegion, (Double)0.0);
            AnchorPane.setRightAnchor((Node)comboRegion, (Double)0.0);
            struc.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    ((Node)struc.getChildren().getFirst()).requestFocus();
                }
            });
        });
        return stack;
    }
}

