/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.KeyFileStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import lombok.Generated;

@JsonTypeName(value="syncedIdentity")
@JsonDeserialize(builder=SyncedIdentityStoreBuilderImpl.class)
public final class SyncedIdentityStore
extends IdentityStore
implements UserScopeStore {
    private final String username;
    private final EncryptedValue.VaultKey<SecretRetrievalStrategy> password;
    private final EncryptedValue.VaultKey<SshIdentityStrategy> sshIdentity;
    private final boolean perUser;

    @Override
    public UsernameStrategy.Fixed getUsername() {
        return new UsernameStrategy.Fixed(this.username);
    }

    @Override
    public SecretRetrievalStrategy getPassword() {
        return this.password != null ? (SecretRetrievalStrategy)this.password.getValue() : null;
    }

    @Override
    public SshIdentityStrategy getSshIdentity() {
        return this.sshIdentity != null ? (SshIdentityStrategy)this.sshIdentity.getValue() : null;
    }

    @Override
    public void checkComplete() throws Throwable {
        KeyFileStrategy f;
        super.checkComplete();
        SshIdentityStrategy sshIdentityStrategy = this.getSshIdentity();
        if (sshIdentityStrategy instanceof KeyFileStrategy && !(f = (KeyFileStrategy)sshIdentityStrategy).getFile().isInDataDirectory()) {
            throw new ValidationException("Key file is not synced");
        }
    }

    EncryptedValue.VaultKey<SecretRetrievalStrategy> getEncryptedPassword() {
        return this.password;
    }

    EncryptedValue.VaultKey<SshIdentityStrategy> getEncryptedSshIdentity() {
        return this.sshIdentity;
    }

    @Generated
    protected SyncedIdentityStore(SyncedIdentityStoreBuilder<?, ?> b) {
        super(b);
        this.username = b.username;
        this.password = b.password;
        this.sshIdentity = b.sshIdentity;
        this.perUser = b.perUser;
    }

    @Generated
    public static SyncedIdentityStoreBuilder<?, ?> builder() {
        return new SyncedIdentityStoreBuilderImpl();
    }

    @Generated
    public boolean isPerUser() {
        return this.perUser;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncedIdentityStore)) {
            return false;
        }
        SyncedIdentityStore other = (SyncedIdentityStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPerUser() != other.isPerUser()) {
            return false;
        }
        UsernameStrategy.Fixed this$username = this.getUsername();
        UsernameStrategy.Fixed other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        SshIdentityStrategy this$sshIdentity = this.getSshIdentity();
        SshIdentityStrategy other$sshIdentity = other.getSshIdentity();
        return !(this$sshIdentity == null ? other$sshIdentity != null : !this$sshIdentity.equals(other$sshIdentity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SyncedIdentityStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPerUser() ? 79 : 97);
        UsernameStrategy.Fixed $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        SshIdentityStrategy $sshIdentity = this.getSshIdentity();
        result = result * 59 + ($sshIdentity == null ? 43 : $sshIdentity.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SyncedIdentityStore(super=" + super.toString() + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", sshIdentity=" + String.valueOf(this.getSshIdentity()) + ", perUser=" + this.isPerUser() + ")";
    }

    @Generated
    public static abstract class SyncedIdentityStoreBuilder<C extends SyncedIdentityStore, B extends SyncedIdentityStoreBuilder<C, B>>
    extends IdentityStore.IdentityStoreBuilder<C, B> {
        @Generated
        private String username;
        @Generated
        private EncryptedValue.VaultKey<SecretRetrievalStrategy> password;
        @Generated
        private EncryptedValue.VaultKey<SshIdentityStrategy> sshIdentity;
        @Generated
        private boolean perUser;

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(EncryptedValue.VaultKey<SecretRetrievalStrategy> password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B sshIdentity(EncryptedValue.VaultKey<SshIdentityStrategy> sshIdentity) {
            this.sshIdentity = sshIdentity;
            return (B)this.self();
        }

        @Generated
        public B perUser(boolean perUser) {
            this.perUser = perUser;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SyncedIdentityStore.SyncedIdentityStoreBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + String.valueOf(this.password) + ", sshIdentity=" + String.valueOf(this.sshIdentity) + ", perUser=" + this.perUser + ")";
        }
    }

    @JsonTypeName(value="syncedIdentity")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SyncedIdentityStoreBuilderImpl
    extends SyncedIdentityStoreBuilder<SyncedIdentityStore, SyncedIdentityStoreBuilderImpl> {
        @Generated
        private SyncedIdentityStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected SyncedIdentityStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SyncedIdentityStore build() {
            return new SyncedIdentityStore(this);
        }
    }
}

