/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.core.FailableSupplier;
import java.util.Optional;
import lombok.Generated;

public interface UsernameStrategy {
    public boolean hasUser();

    public Optional<String> getFixedUsername();

    public String retrieveUsername() throws Exception;

    public static final class Dynamic
    implements UsernameStrategy {
        private final FailableSupplier<String> username;

        public Dynamic(FailableSupplier<String> username) {
            this.username = username;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Dynamic;
        }

        public String toString() {
            return "<dynamic>";
        }

        @Override
        public boolean hasUser() {
            return true;
        }

        @Override
        public Optional<String> getFixedUsername() {
            return Optional.empty();
        }

        @Override
        public String retrieveUsername() throws Exception {
            String r = (String)this.username.get();
            return r;
        }
    }

    public static final class Fixed
    implements UsernameStrategy {
        private final String username;

        public Fixed(String username) {
            this.username = username;
        }

        public String get() {
            return this.username;
        }

        @Override
        public boolean hasUser() {
            return this.getFixedUsername().isPresent();
        }

        @Override
        public Optional<String> getFixedUsername() {
            return Optional.ofNullable(this.username);
        }

        @Override
        public String retrieveUsername() {
            return this.getFixedUsername().orElseThrow();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fixed)) {
                return false;
            }
            Fixed other = (Fixed)o;
            String this$username = this.username;
            String other$username = other.username;
            return !(this$username == null ? other$username != null : !this$username.equals(other$username));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.username;
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UsernameStrategy.Fixed(username=" + this.username + ")";
        }
    }

    public static class None
    implements UsernameStrategy {
        @Override
        public boolean hasUser() {
            return false;
        }

        @Override
        public Optional<String> getFixedUsername() {
            return Optional.empty();
        }

        @Override
        public String retrieveUsername() {
            return null;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof None)) {
                return false;
            }
            None other = (None)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof None;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "UsernameStrategy.None()";
        }
    }
}

