/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStateManager;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import lombok.Generated;

@JsonTypeName(value="otherExternal")
@JsonDeserialize(builder=OtherExternalAgentStrategyBuilder.class)
public final class OtherExternalAgentStrategy
implements SshIdentityStrategy {
    private final boolean forwardAgent;
    private final String publicKey;

    public static OptionsBuilder createOptions(Property<OtherExternalAgentStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleBooleanProperty forward = new SimpleBooleanProperty(p.getValue() != null && ((OtherExternalAgentStrategy)p.getValue()).isForwardAgent());
        SimpleStringProperty publicKey = new SimpleStringProperty(p.getValue() != null ? ((OtherExternalAgentStrategy)p.getValue()).getPublicKey() : null);
        return new OptionsBuilder().nameAndDescription("forwardAgent").addToggle((Property)forward).nonNull().hide(!config.isAllowAgentForward()).nameAndDescription("publicKey").addComp((BaseRegionBuilder)new TextFieldComp((Property)publicKey).apply(struc -> struc.setPromptText("ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAIBmhLUTJiP...== Your Comment")), (Property)publicKey).bind(() -> new OtherExternalAgentStrategy(forward.get(), publicKey.get()), new Property[]{p});
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (parent.isLocal()) {
            SshIdentityStateManager.prepareLocalExternalAgent();
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) throws Exception {
        Optional<FilePath> file = SshIdentityStrategy.getPublicKeyPath(sc, this.publicKey);
        return List.of(new KeyValue("IdentitiesOnly", file.isPresent() ? "yes" : "no"), new KeyValue("ForwardAgent", this.forwardAgent ? "yes" : "no"), new KeyValue("IdentityFile", file.isPresent() ? file.get().toString() : "none"), new KeyValue("PKCS11Provider", "none"));
    }

    @Generated
    OtherExternalAgentStrategy(boolean forwardAgent, String publicKey) {
        this.forwardAgent = forwardAgent;
        this.publicKey = publicKey;
    }

    @Generated
    public static OtherExternalAgentStrategyBuilder builder() {
        return new OtherExternalAgentStrategyBuilder();
    }

    @Generated
    public boolean isForwardAgent() {
        return this.forwardAgent;
    }

    @Override
    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtherExternalAgentStrategy)) {
            return false;
        }
        OtherExternalAgentStrategy other = (OtherExternalAgentStrategy)o;
        if (this.isForwardAgent() != other.isForwardAgent()) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForwardAgent() ? 79 : 97);
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OtherExternalAgentStrategy(forwardAgent=" + this.isForwardAgent() + ", publicKey=" + this.getPublicKey() + ")";
    }

    @JsonTypeName(value="otherExternal")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class OtherExternalAgentStrategyBuilder {
        @Generated
        private boolean forwardAgent;
        @Generated
        private String publicKey;

        @Generated
        OtherExternalAgentStrategyBuilder() {
        }

        @Generated
        public OtherExternalAgentStrategyBuilder forwardAgent(boolean forwardAgent) {
            this.forwardAgent = forwardAgent;
            return this;
        }

        @Generated
        public OtherExternalAgentStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public OtherExternalAgentStrategy build() {
            return new OtherExternalAgentStrategy(this.forwardAgent, this.publicKey);
        }

        @Generated
        public String toString() {
            return "OtherExternalAgentStrategy.OtherExternalAgentStrategyBuilder(forwardAgent=" + this.forwardAgent + ", publicKey=" + this.publicKey + ")";
        }
    }
}

