/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonTypeName(value="yubikeyPiv")
@JsonDeserialize(builder=YubikeyPivStrategyBuilder.class)
public final class YubikeyPivStrategy
implements SshIdentityStrategy {
    private String getFile(ShellControl sc) {
        OsType.Any any = sc.getOsType();
        Objects.requireNonNull(any);
        OsType.Any any2 = any;
        int n = 0;
        String file = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.MacOs.class, OsType.Windows.class}, (OsType.Any)any2, n)) {
            case 0 -> {
                OsType.MacOs ignored = (OsType.MacOs)any2;
                yield "/usr/local/lib/libykcs11.dylib";
            }
            case 1 -> {
                OsType.Windows ignored = (OsType.Windows)any2;
                String x64 = "C:\\Program Files\\Yubico\\Yubico PIV Tool\\bin\\libykcs11.dll";
                if (Files.exists(Path.of(x64, new String[0]), new LinkOption[0])) {
                    yield x64;
                }
                String x86 = "C:\\Program Files (x86)\\Yubico\\Yubico PIV Tool\\bin\\libykcs11.dll";
                if (Files.exists(Path.of(x86, new String[0]), new LinkOption[0])) {
                    yield x86;
                }
                yield x64;
            }
            default -> "/usr/local/lib/libykcs11.so";
        };
        return file;
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        parent.requireLicensedFeature(LicenseProvider.get().getFeature("pkcs11Identity"));
        String file = this.getFile(parent);
        if (!parent.getShellDialect().createFileExistsCommand(parent, file).executeAndCheck()) {
            throw (IOException)ErrorEventFactory.expected((Throwable)new IOException("Yubikey PKCS11 library at " + file + " not found"));
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.setup(sc -> {
            String file = this.getFile((ShellControl)sc);
            FilePath dir = FilePath.of((String)file).getParent();
            if (sc.getOsType() == OsType.WINDOWS) {
                builder.addToPath(dir, true);
            } else {
                builder.addToEnvironmentPath("LD_LIBRARY_PATH", dir, true);
            }
        });
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) {
        return List.of(new KeyValue("IdentitiesOnly", "no"), new KeyValue("PKCS11Provider", "\"" + this.getFile(sc) + "\""), new KeyValue("IdentityFile", "none"), new KeyValue("IdentityAgent", "none"));
    }

    @Override
    public String getPublicKey() {
        return null;
    }

    @Generated
    public static YubikeyPivStrategyBuilder builder() {
        return new YubikeyPivStrategyBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof YubikeyPivStrategy;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "YubikeyPivStrategy()";
    }

    @Generated
    public YubikeyPivStrategy() {
    }

    @JsonTypeName(value="yubikeyPiv")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class YubikeyPivStrategyBuilder {
        @Generated
        YubikeyPivStrategyBuilder() {
        }

        @Generated
        public YubikeyPivStrategy build() {
            return new YubikeyPivStrategy();
        }

        @Generated
        public String toString() {
            return "YubikeyPivStrategy.YubikeyPivStrategyBuilder()";
        }
    }
}

