/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.core.AppNames;
import io.xpipe.app.core.AppResources;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptTextSource;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;

public enum PredefinedScriptStore {
    APT_UPDATE("Apt upgrade", () -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(ScriptTextSource.InPlace.builder().dialect(ShellDialects.SH).text(PredefinedScriptStore.file("apt_upgrade.sh")).build())).shellScript(true)).runnableScript(true)).build()),
    REMOVE_CR("CRLF to LF", () -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(ScriptTextSource.InPlace.builder().dialect(ShellDialects.SH).text(PredefinedScriptStore.file("crlf_to_lf.sh")).build())).fileScript(true)).shellScript(true)).build()),
    DIFF("Diff", () -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(ScriptTextSource.InPlace.builder().dialect(ShellDialects.SH).text(PredefinedScriptStore.file("diff.sh")).build())).fileScript(true)).build()),
    GIT_CONFIG("Git Config", () -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(ScriptTextSource.InPlace.builder().text(PredefinedScriptStore.file("git_config.sh")).build())).runnableScript(true)).build()),
    SYSTEM_HEALTH_STATUS("System health status", () -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(ScriptTextSource.InPlace.builder().dialect(ShellDialects.SH).text(PredefinedScriptStore.file("system_health.sh")).build())).initScript(true)).build());

    private final String name;
    private final Supplier<ScriptStore> scriptStore;
    private final UUID uuid;
    private DataStoreEntryRef<ScriptStore> entry;

    private PredefinedScriptStore(String name, Supplier<ScriptStore> scriptStore) {
        this.name = name;
        this.scriptStore = scriptStore;
        this.uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
    }

    public static ShellScript file(String name) {
        AtomicReference string = new AtomicReference();
        AppResources.with((String)AppNames.extModuleName((String)"base"), (String)("scripts/" + name), var1 -> string.set(Files.readString(var1)));
        return ShellScript.of((String)((String)string.get()));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Supplier<ScriptStore> getScriptStore() {
        return this.scriptStore;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public DataStoreEntryRef<ScriptStore> getEntry() {
        return this.entry;
    }

    @Generated
    public void setEntry(DataStoreEntryRef<ScriptStore> entry) {
        this.entry = entry;
    }
}

