/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.browser.file.BrowserEntry;
import io.xpipe.app.browser.file.BrowserFileSystemTabModel;
import io.xpipe.app.browser.menu.BrowserMenuBranchProvider;
import io.xpipe.app.browser.menu.BrowserMenuCategory;
import io.xpipe.app.browser.menu.BrowserMenuItemProvider;
import io.xpipe.app.browser.menu.BrowserMenuLeafProvider;
import io.xpipe.app.browser.menu.MultiExecuteMenuProvider;
import io.xpipe.app.comp.base.PrettyImageHelper;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppLayoutModel;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ScriptHelper;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategoryConfig;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.script.ScriptHierarchy;
import io.xpipe.ext.base.script.ScriptStore;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;

public class RunFileScriptMenuProvider
implements BrowserMenuBranchProvider {
    public LabelGraphic getIcon() {
        return new LabelGraphic.IconGraphic("mdi2c-code-greater-than");
    }

    public BrowserMenuCategory getCategory() {
        return BrowserMenuCategory.ACTION;
    }

    public ObservableValue<String> getName(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
        return AppI18n.observable((String)"runScript", (Object[])new Object[0]);
    }

    public boolean isApplicable(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
        if (model.getFileSystem().getShell().isEmpty()) {
            return false;
        }
        return model.getBrowserModel() instanceof BrowserFullSessionModel;
    }

    public List<? extends BrowserMenuItemProvider> getBranchingActions(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
        DataStoreCategoryConfig config = DataStorage.get().getEffectiveCategoryConfig(model.getEntry().get());
        if (Boolean.TRUE.equals(config.getDontAllowScripts())) {
            return List.of(new BrowserMenuLeafProvider(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public ObservableValue<String> getName(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                    return AppI18n.observable((String)"scriptsDisabled", (Object[])new Object[0]);
                }
            });
        }
        List<Object> actions = this.createActionForScriptHierarchy(model, entries);
        if (actions.isEmpty()) {
            actions = List.of(new BrowserMenuLeafProvider(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public void execute(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                    StoreViewState.get().getAllScriptsCategory().select();
                    AppLayoutModel.get().selectConnections();
                }

                public ObservableValue<String> getName(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                    return AppI18n.observable((String)"noScriptsAvailable", (Object[])new Object[0]);
                }
            });
        }
        return actions;
    }

    private List<? extends BrowserMenuItemProvider> createActionForScriptHierarchy(BrowserFileSystemTabModel model, List<BrowserEntry> selected) {
        ShellControl sc = (ShellControl)model.getFileSystem().getShell().orElseThrow();
        ScriptHierarchy hierarchy = ScriptHierarchy.buildEnabledHierarchy(ref -> {
            if (!((ScriptStore)ref.getStore()).isFileScript()) {
                return false;
            }
            return ((ScriptStore)ref.getStore()).isCompatible(sc);
        });
        return this.createActionForScriptHierarchy(hierarchy).getBranchingActions(model, selected);
    }

    private BrowserMenuBranchProvider createActionForScriptHierarchy(final ScriptHierarchy hierarchy) {
        if (hierarchy.isLeaf()) {
            return this.createActionForScript(hierarchy.getScript());
        }
        final List<BrowserMenuBranchProvider> list = hierarchy.getChildren().stream().map(c -> this.createActionForScriptHierarchy((ScriptHierarchy)c)).toList();
        return new BrowserMenuBranchProvider(){
            {
                Objects.requireNonNull(this$0);
            }

            public LabelGraphic getIcon() {
                if (!hierarchy.isLeaf()) {
                    return null;
                }
                return new LabelGraphic.CompGraphic(PrettyImageHelper.ofFixedSize((String)hierarchy.getScript().get().getEffectiveIconFile(), (int)16, (int)16));
            }

            public ObservableValue<String> getName(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                return new SimpleStringProperty(hierarchy.getName());
            }

            public List<? extends BrowserMenuItemProvider> getBranchingActions(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                return list;
            }
        };
    }

    private BrowserMenuBranchProvider createActionForScript(final DataStoreEntryRef<ScriptStore> ref) {
        return new MultiExecuteMenuProvider(this){
            {
                Objects.requireNonNull(this$0);
            }

            public LabelGraphic getIcon() {
                return new LabelGraphic.CompGraphic(PrettyImageHelper.ofFixedSize((String)ref.get().getEffectiveIconFile(), (int)16, (int)16));
            }

            public ObservableValue<String> getName(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                return new SimpleStringProperty(ref.get().getName());
            }

            protected List<CommandBuilder> createCommand(BrowserFileSystemTabModel model, List<BrowserEntry> entries) {
                ShellControl sc = (ShellControl)model.getFileSystem().getShell().orElseThrow();
                ShellScript content = ((ScriptStore)ref.getStore()).assembleScriptChain(sc, true);
                if (content == null) {
                    return List.of();
                }
                FilePath script = ScriptHelper.createExecScript((ShellControl)sc, (String)content.getValue());
                CommandBuilder builder = CommandBuilder.of().add(new String[]{sc.getShellDialect().runScriptCommand(sc, script.toString())});
                for (BrowserEntry entry : entries) {
                    builder.addFile(entry.getRawFileEntry().getPath());
                }
                return List.of(builder);
            }
        };
    }
}

