/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.base.ContextualFileReferenceChoiceComp;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.UuidHelper;
import io.xpipe.ext.base.script.ScriptCollectionSourceEntry;
import io.xpipe.ext.base.script.ScriptDialects;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Directory.class), @JsonSubTypes.Type(value=GitRepository.class)})
public interface ScriptCollectionSource {
    public void checkComplete() throws ValidationException;

    public void prepare() throws Exception;

    public Path getLocalPath();

    public String toSummary();

    public String toName();

    default public List<ScriptCollectionSourceEntry> listScripts() {
        final List<ShellDialect> availableDialects = ScriptDialects.getSupported();
        final ArrayList<ScriptCollectionSourceEntry> l = new ArrayList<ScriptCollectionSourceEntry>();
        if (!Files.exists(this.getLocalPath(), new LinkOption[0])) {
            return l;
        }
        try {
            Files.walkFileTree(this.getLocalPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                final /* synthetic */ ScriptCollectionSource this$0;
                {
                    ScriptCollectionSource scriptCollectionSource = this$0;
                    Objects.requireNonNull(scriptCollectionSource);
                    this.this$0 = scriptCollectionSource;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String name = file.getFileName().toString();
                    Optional<ShellDialect> dialect = availableDialects.stream().filter(shellDialect -> name.endsWith("." + shellDialect.getScriptFileEnding())).findFirst();
                    if (dialect.isEmpty()) {
                        return FileVisitResult.CONTINUE;
                    }
                    ScriptCollectionSourceEntry entry = ScriptCollectionSourceEntry.builder().name(name).source(this.this$0).dialect(dialect.get()).localFile(file).build();
                    l.add(entry);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            ErrorEventFactory.fromThrowable((Throwable)e).expected().handle();
        }
        return l;
    }

    public static List<Class<?>> getClasses() {
        ArrayList l = new ArrayList();
        l.add(Directory.class);
        l.add(GitRepository.class);
        return l;
    }

    @JsonTypeName(value="directory")
    @JsonDeserialize(builder=DirectoryBuilder.class)
    public static final class Directory
    implements ScriptCollectionSource {
        private final Path path;

        static OptionsBuilder createOptions(Property<Directory> property) {
            SimpleObjectProperty path = new SimpleObjectProperty(((Directory)property.getValue()).getPath() != null ? FilePath.of((Path)((Directory)property.getValue()).getPath()) : null);
            return new OptionsBuilder().nameAndDescription("scriptDirectory").addComp((BaseRegionBuilder)new ContextualFileReferenceChoiceComp((ObservableValue)new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref()), (Property)path, null, List.of(), entry -> DataStorage.get().local().equals(entry), true), (Property)path).nonNull().bind(() -> Directory.builder().path(path.get() != null ? ((FilePath)path.get()).asLocalPath() : null).build(), new Property[]{property});
        }

        @Override
        public void checkComplete() throws ValidationException {
            Validators.nonNull((Object)this.path);
        }

        @Override
        public void prepare() {
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Source directory " + String.valueOf(this.path) + " does not exist"));
            }
        }

        @Override
        public Path getLocalPath() {
            return this.path;
        }

        @Override
        public String toSummary() {
            return this.path.toString();
        }

        @Override
        public String toName() {
            return AppI18n.get((String)"directorySource", (Object[])new Object[0]);
        }

        @Generated
        Directory(Path path) {
            this.path = path;
        }

        @Generated
        public static DirectoryBuilder builder() {
            return new DirectoryBuilder();
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Directory)) {
                return false;
            }
            Directory other = (Directory)o;
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScriptCollectionSource.Directory(path=" + String.valueOf(this.getPath()) + ")";
        }

        @JsonTypeName(value="directory")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class DirectoryBuilder {
            @Generated
            private Path path;

            @Generated
            DirectoryBuilder() {
            }

            @Generated
            public DirectoryBuilder path(Path path) {
                this.path = path;
                return this;
            }

            @Generated
            public Directory build() {
                return new Directory(this.path);
            }

            @Generated
            public String toString() {
                return "ScriptCollectionSource.Directory.DirectoryBuilder(path=" + String.valueOf(this.path) + ")";
            }
        }
    }

    @JsonTypeName(value="gitRepository")
    @JsonDeserialize(builder=GitRepositoryBuilder.class)
    public static final class GitRepository
    implements ScriptCollectionSource {
        private final String url;

        static OptionsBuilder createOptions(Property<GitRepository> property) {
            SimpleStringProperty url = new SimpleStringProperty(((GitRepository)property.getValue()).getUrl());
            return new OptionsBuilder().nameAndDescription("scriptSourceUrl").addString((Property)url).nonNull().bind(() -> GitRepository.builder().url(url.get()).build(), new Property[]{property});
        }

        private String getName() {
            String name = FilePath.of((String)this.url).getFileName();
            if (!name.isEmpty()) {
                return name;
            }
            return UuidHelper.generateFromObject((Object[])new Object[]{this.url}).toString();
        }

        @Override
        public void checkComplete() throws ValidationException {
            Validators.nonNull((Object)this.url);
        }

        @Override
        public void prepare() throws Exception {
            if (Files.exists(this.getLocalPath(), new LinkOption[0])) {
                ProcessControlProvider.get().pullRepository(this.getLocalPath());
            } else {
                ProcessControlProvider.get().cloneRepository(this.url, this.getLocalPath());
            }
        }

        @Override
        public Path getLocalPath() {
            return AppCache.getBasePath().resolve("scripts").resolve(this.getName());
        }

        @Override
        public String toSummary() {
            return this.url.replace("http://", "").replace("https://", "").replace("file://", "").replace("ssh://", "");
        }

        @Override
        public String toName() {
            return AppI18n.get((String)"gitRepositorySource", (Object[])new Object[0]);
        }

        @Generated
        GitRepository(String url) {
            this.url = url;
        }

        @Generated
        public static GitRepositoryBuilder builder() {
            return new GitRepositoryBuilder();
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitRepository)) {
                return false;
            }
            GitRepository other = (GitRepository)o;
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScriptCollectionSource.GitRepository(url=" + this.getUrl() + ")";
        }

        @JsonTypeName(value="gitRepository")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class GitRepositoryBuilder {
            @Generated
            private String url;

            @Generated
            GitRepositoryBuilder() {
            }

            @Generated
            public GitRepositoryBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public GitRepository build() {
                return new GitRepository(this.url);
            }

            @Generated
            public String toString() {
                return "ScriptCollectionSource.GitRepository.GitRepositoryBuilder(url=" + this.url + ")";
            }
        }
    }
}

