/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.RegionBuilder;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.FilterComp;
import io.xpipe.app.comp.base.LabelComp;
import io.xpipe.app.comp.base.ListSelectorComp;
import io.xpipe.app.comp.base.ModalButton;
import io.xpipe.app.comp.base.ModalOverlay;
import io.xpipe.app.comp.base.StackComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.ShellDialectIcons;
import io.xpipe.app.hub.comp.DataStoreCategoryChoiceComp;
import io.xpipe.app.hub.comp.StoreCategoryWrapper;
import io.xpipe.app.hub.comp.StoreCreationDialog;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.DerivedObservableList;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BooleanScope;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.script.ScriptCollectionSourceEntry;
import io.xpipe.ext.base.script.ScriptCollectionSourceStore;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptTextSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.kordamp.ikonli.javafx.FontIcon;

public class ScriptCollectionSourceImportDialog {
    private final DataStoreEntryRef<ScriptCollectionSourceStore> source;
    private final ObservableList<ScriptCollectionSourceEntry> available = FXCollections.observableArrayList();
    private final ObservableList<ScriptCollectionSourceEntry> shown = FXCollections.observableArrayList();
    private final ObservableList<ScriptCollectionSourceEntry> selected = FXCollections.observableArrayList();
    private final StringProperty filter = new SimpleStringProperty();
    private final BooleanProperty busy = new SimpleBooleanProperty();
    private final ObjectProperty<StoreCategoryWrapper> targetCategory = new SimpleObjectProperty();

    public ScriptCollectionSourceImportDialog(DataStoreEntryRef<ScriptCollectionSourceStore> source) {
        this.source = source;
        this.available.setAll(((ScriptCollectionSourceStore)source.getStore()).getSource().listScripts());
        this.update();
        this.filter.addListener((observable, oldValue, newValue) -> this.update());
        this.targetCategory.set((Object)this.findDefaultCategory());
    }

    private StoreCategoryWrapper findDefaultCategory() {
        DerivedObservableList all = StoreViewState.get().getSortedCategories(StoreViewState.get().getAllScriptsCategory()).filtered(w -> w.getParent() != null && !w.getCategory().getUuid().equals(DataStorage.PREDEFINED_SCRIPTS_CATEGORY_UUID) && !w.getCategory().getUuid().equals(DataStorage.SCRIPT_SOURCES_CATEGORY_UUID));
        return all.getList().size() > 0 ? (StoreCategoryWrapper)all.getList().getFirst() : null;
    }

    public void show() {
        RegionBuilder filterField = (RegionBuilder)new FilterComp((Property)this.filter).hgrow();
        filterField.apply(r -> {
            HBox.setHgrow((Node)r, (Priority)Priority.SOMETIMES);
            r.sceneProperty().subscribe(s -> {
                if (s != null) {
                    Platform.runLater(() -> Platform.runLater(() -> r.requestFocus()));
                }
            });
        });
        RegionBuilder refresh = (RegionBuilder)new ButtonComp(null, (Node)new FontIcon("mdmz-refresh"), () -> ThreadHelper.runAsync(() -> {
            try (BooleanScope ignored = new BooleanScope(this.busy).exclusive().start();){
                ((ScriptCollectionSourceStore)this.source.getStore()).getSource().prepare();
                List<ScriptCollectionSourceEntry> all = ((ScriptCollectionSourceStore)this.source.getStore()).getSource().listScripts();
                this.available.setAll(all);
                this.update();
            }
            catch (Exception e) {
                ErrorEventFactory.fromThrowable((Throwable)e).handle();
            }
        })).maxHeight(100.0);
        LabelComp notFound = new LabelComp(AppI18n.observable((String)"noScriptsFound", (Object[])new Object[0]));
        notFound.show((ObservableValue)Bindings.isEmpty(this.shown).and((ObservableBooleanValue)this.busy.not()));
        ListSelectorComp selector = new ListSelectorComp(this.shown, e -> e.getName() + " [" + e.getDialect().getDisplayName() + "]", e -> new LabelGraphic.ImageGraphic(ShellDialectIcons.getImageName((ShellDialect)e.getDialect()), 16), this.selected, e -> false, () -> this.shown.size() > 0);
        selector.disable((ObservableValue)this.busy);
        StackComp stack = new StackComp(List.of(notFound, selector));
        stack.prefWidth(600.0);
        stack.prefHeight(650.0);
        DataStoreCategoryChoiceComp catChoice = new DataStoreCategoryChoiceComp(StoreViewState.get().getAllScriptsCategory(), StoreViewState.get().getActiveCategory(), this.targetCategory, false, w -> w.getParent() != null && !w.equals(StoreViewState.get().getScriptSourcesCategory()));
        catChoice.hgrow();
        catChoice.maxHeight(100.0);
        ModalOverlay modal = ModalOverlay.of((ObservableValue)Bindings.createStringBinding(() -> AppI18n.get((String)"scriptSourceCollectionImportTitle", (Object[])new Object[]{this.selected.size(), this.available.size()}), (Observable[])new Observable[]{this.available, this.selected, AppI18n.activeLanguage()}), (BaseRegionBuilder)stack, null);
        modal.addButtonBarComp((BaseRegionBuilder)refresh);
        modal.addButtonBarComp((BaseRegionBuilder)filterField);
        modal.addButtonBarComp((BaseRegionBuilder)catChoice);
        modal.addButton(ModalButton.ok(() -> ThreadHelper.runAsync(() -> this.finish()))).augment(button -> button.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.selected).or((ObservableBooleanValue)this.targetCategory.isNull())));
        modal.show();
    }

    private void finish() {
        StoreViewState.get().selectCategoryIntoViewIfNeeded((StoreCategoryWrapper)this.targetCategory.getValue());
        ArrayList<DataStoreEntry> added = new ArrayList<DataStoreEntry>();
        for (ScriptCollectionSourceEntry e : this.selected) {
            String name = FilePath.of((String)e.getName()).getBaseName().toString();
            ScriptTextSource.SourceReference textSource = ScriptTextSource.SourceReference.builder().ref(this.source).name(e.getName()).build();
            boolean alreadyAdded = DataStorage.get().getStoreEntries().stream().anyMatch(entry -> {
                ScriptStore ss;
                DataStore patt0$temp = entry.getStore();
                return patt0$temp instanceof ScriptStore && textSource.equals((ss = (ScriptStore)patt0$temp).getTextSource());
            });
            if (alreadyAdded) continue;
            Object store = ((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource(textSource)).build();
            DataStoreEntry entry2 = DataStoreEntry.createNew((String)name, store);
            entry2.setCategoryUuid(((StoreCategoryWrapper)this.targetCategory.getValue()).getCategory().getUuid());
            DataStorage.get().addStoreEntryIfNotPresent(entry2);
            added.add(entry2);
        }
        if (added.size() == 1) {
            StoreCreationDialog.showEdit((DataStoreEntry)((DataStoreEntry)added.getFirst()));
        }
    }

    private void update() {
        if (this.filter.get() == null) {
            this.shown.setAll(this.available);
            return;
        }
        String f = ((String)this.filter.get()).toLowerCase();
        List<ScriptCollectionSourceEntry> filtered = this.available.stream().filter(e -> e.getName().toLowerCase().contains(f)).toList();
        ArrayList<ScriptCollectionSourceEntry> newList = new ArrayList<ScriptCollectionSourceEntry>();
        newList.addAll((Collection<ScriptCollectionSourceEntry>)this.selected);
        newList.addAll(filtered);
        this.shown.setAll(newList);
    }
}

