/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.ext.base.script.ScriptCollectionSource;
import io.xpipe.ext.base.script.ScriptCollectionSourceStore;
import java.util.List;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class ScriptCollectionSourceStoreProvider
implements DataStoreProvider {
    public int getOrderPriority() {
        return 1;
    }

    public UUID getTargetCategory(DataStore store, UUID target) {
        return DataStorage.SCRIPT_SOURCES_CATEGORY_UUID;
    }

    public DocumentationLink getHelpLink() {
        return DocumentationLink.SCRIPTING;
    }

    public boolean canMoveCategories() {
        return false;
    }

    public boolean shouldShowScan() {
        return false;
    }

    public BaseRegionBuilder<?, ?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SCRIPT;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        ScriptCollectionSourceStore st = (ScriptCollectionSourceStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty source = new SimpleObjectProperty((Object)st.getSource());
        OptionsChoiceBuilder sourceChoice = OptionsChoiceBuilder.builder().property((Property)source).available(ScriptCollectionSource.getClasses()).build();
        return new OptionsBuilder().nameAndDescription("scriptCollectionSourceType").sub(sourceChoice.build(), (Property)source).nonNull().bind(() -> ((ScriptCollectionSourceStore.ScriptCollectionSourceStoreBuilder)ScriptCollectionSourceStore.builder().source((ScriptCollectionSource)source.get())).build(), new Property[]{store}).buildDialog();
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        ScriptCollectionSourceStore st = (ScriptCollectionSourceStore)wrapper.getEntry().getStore().asNeeded();
        return st.getSource().toName();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ScriptCollectionSourceStore st = (ScriptCollectionSourceStore)section.getWrapper().getEntry().getStore().asNeeded();
        return Bindings.createStringBinding(() -> {
            ScriptCollectionSourceStore.State s = (ScriptCollectionSourceStore.State)st.getState();
            String summary = st.getSource().toSummary();
            boolean init = s.getEntries() != null;
            StoreStateFormat format = new StoreStateFormat(List.of(), summary, new String[]{init ? AppI18n.get((String)"scriptsContained", (Object[])new Object[]{s.getEntries().size()}) : null, !init ? AppI18n.get((String)"notInitialized", (Object[])new Object[0]) : null});
            return format.format();
        }, (Observable[])new Observable[]{section.getWrapper().getPersistentState(), AppI18n.activeLanguage()});
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ScriptCollectionSourceStore.builder().build();
    }

    public String getId() {
        return "scriptCollectionSource";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(ScriptCollectionSourceStore.class);
    }
}

