/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.ext.DataStorageExtensionProvider;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.PredefinedScriptStore;
import io.xpipe.ext.base.script.ScriptStore;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class ScriptDataStorageProvider
extends DataStorageExtensionProvider {
    public void storageInit() {
        if (AppProperties.get().isNewBuildSession()) {
            List<DataStoreEntry> legacyLeftovers = DataStorage.get().getStoreEntries().stream().filter(entry -> entry.getValidity() == DataStoreEntry.Validity.LOAD_FAILED && ("My scripts".equals(entry.getName()) || "Files".equals(entry.getName()) || "Management".equals(entry.getName()))).toList();
            DataStorage.get().deleteWithChildren((DataStoreEntry[])legacyLeftovers.toArray(DataStoreEntry[]::new));
        }
        if (!AppProperties.get().isInitialLaunch()) {
            return;
        }
        if (AppProperties.get().isTest()) {
            return;
        }
        for (PredefinedScriptStore value : PredefinedScriptStore.values()) {
            Optional previous = DataStorage.get().getStoreEntryIfPresent(value.getUuid());
            ScriptStore store = value.getScriptStore().get();
            if (previous.isPresent()) {
                DataStorage.get().updateEntryStore((DataStoreEntry)previous.get(), (DataStore)store);
                value.setEntry((DataStoreEntryRef<ScriptStore>)((DataStoreEntry)previous.get()).ref());
                continue;
            }
            DataStoreEntry e = DataStoreEntry.createNew((UUID)value.getUuid(), (UUID)DataStorage.PREDEFINED_SCRIPTS_CATEGORY_UUID, (String)value.getName(), (DataStore)store);
            DataStorage.get().addStoreEntryIfNotPresent(e);
            value.setEntry((DataStoreEntryRef<ScriptStore>)e.ref());
        }
    }
}

