/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptStoreSetup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

public final class ScriptHierarchy {
    private final String name;
    private final DataStoreCategory category;
    private final DataStoreEntryRef<ScriptStore> script;
    private final List<ScriptHierarchy> children;

    public static ScriptHierarchy buildEnabledHierarchy(Predicate<DataStoreEntryRef<ScriptStore>> include) {
        boolean changed;
        List<DataStoreEntryRef<ScriptStore>> enabled = ScriptStoreSetup.getEnabledScripts().stream().filter(include).toList();
        HashSet categories = new HashSet();
        for (DataStoreEntryRef<ScriptStore> ref : enabled) {
            DataStoreCategory cat = DataStorage.get().getStoreCategory(ref.get());
            List catParents = DataStorage.get().getCategoryParentHierarchy(cat);
            categories.addAll(catParents);
        }
        ScriptHierarchy hierarchy = new ScriptHierarchy(null, null, null, new ArrayList<ScriptHierarchy>());
        do {
            changed = false;
            for (DataStoreCategory cat : categories) {
                boolean alreadyAdded;
                if (cat.getParentCategory() == null) continue;
                ScriptHierarchy toAdd = new ScriptHierarchy(cat.getName(), cat, null, new ArrayList<ScriptHierarchy>());
                if (cat.getParentCategory().equals(DataStorage.ALL_SCRIPTS_CATEGORY_UUID)) {
                    if (hierarchy.getChildren().contains(toAdd)) continue;
                    hierarchy.getChildren().add(toAdd);
                    changed = true;
                    continue;
                }
                Optional<ScriptHierarchy> parentHierarchy = ScriptHierarchy.findParent(hierarchy, cat);
                if (parentHierarchy.isEmpty() || (alreadyAdded = parentHierarchy.get().getChildren().contains(toAdd))) continue;
                parentHierarchy.get().getChildren().add(toAdd);
                changed = true;
            }
        } while (changed);
        for (DataStoreEntryRef<ScriptStore> scriptRef : enabled) {
            Optional<ScriptHierarchy> childTarget;
            DataStoreCategory scriptCategory = DataStorage.get().getStoreCategory(scriptRef.get());
            Optional<ScriptHierarchy> catHierarchy = ScriptHierarchy.findParent(hierarchy, scriptCategory);
            if (catHierarchy.isEmpty() || (childTarget = catHierarchy.get().getChildren().stream().filter(child -> child.getCategory().equals((Object)scriptCategory)).findFirst()).isEmpty()) continue;
            childTarget.get().getChildren().add(new ScriptHierarchy(scriptRef.get().getName(), null, scriptRef, List.of()));
        }
        return ScriptHierarchy.condenseHierarchy(hierarchy);
    }

    private static Optional<ScriptHierarchy> findParent(ScriptHierarchy hierarchy, DataStoreCategory category) {
        if (category.equals((Object)hierarchy.getCategory())) {
            return Optional.of(hierarchy);
        }
        if (hierarchy.getChildren().stream().anyMatch(child -> category.equals((Object)child.getCategory()))) {
            return Optional.of(hierarchy);
        }
        List<ScriptHierarchy> children = hierarchy.getChildren();
        for (ScriptHierarchy child2 : children) {
            Optional<ScriptHierarchy> foundInChild = ScriptHierarchy.findParent(child2, category);
            if (!foundInChild.isPresent()) continue;
            return foundInChild;
        }
        return Optional.empty();
    }

    public static ScriptHierarchy condenseHierarchy(ScriptHierarchy hierarchy) {
        List<ScriptHierarchy> children = hierarchy.getChildren().stream().map(c -> ScriptHierarchy.condenseHierarchy(c)).toList();
        if (children.size() == 1 && !children.getFirst().isLeaf()) {
            List<ScriptHierarchy> nestedChildren = children.getFirst().getChildren();
            return new ScriptHierarchy(children.getFirst().getName(), hierarchy.getCategory(), hierarchy.getScript(), nestedChildren);
        }
        return new ScriptHierarchy(hierarchy.getName(), hierarchy.getCategory(), hierarchy.getScript(), children);
    }

    public boolean show() {
        return this.isLeaf() || !this.isEmptyBranch();
    }

    public boolean isEmptyBranch() {
        if (this.category == null) {
            return false;
        }
        return this.children.isEmpty();
    }

    public boolean isLeaf() {
        return this.script != null;
    }

    @Generated
    public ScriptHierarchy(String name, DataStoreCategory category, DataStoreEntryRef<ScriptStore> script, List<ScriptHierarchy> children) {
        this.name = name;
        this.category = category;
        this.script = script;
        this.children = children;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DataStoreCategory getCategory() {
        return this.category;
    }

    @Generated
    public DataStoreEntryRef<ScriptStore> getScript() {
        return this.script;
    }

    @Generated
    public List<ScriptHierarchy> getChildren() {
        return this.children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptHierarchy)) {
            return false;
        }
        ScriptHierarchy other = (ScriptHierarchy)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DataStoreCategory this$category = this.getCategory();
        DataStoreCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        DataStoreEntryRef<ScriptStore> this$script = this.getScript();
        DataStoreEntryRef<ScriptStore> other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        List<ScriptHierarchy> this$children = this.getChildren();
        List<ScriptHierarchy> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataStoreCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        DataStoreEntryRef<ScriptStore> $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        List<ScriptHierarchy> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScriptHierarchy(name=" + this.getName() + ", category=" + String.valueOf(this.getCategory()) + ", script=" + String.valueOf(this.getScript()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }
}

