/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.hub.comp.StoreCreationDialog;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.FileOpener;
import io.xpipe.ext.base.script.PredefinedScriptStore;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptTextSource;
import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public class ScriptQuickEditHubLeafProvider
implements HubLeafProvider<ScriptStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.CUSTOM;
    }

    public ObservableValue<String> getName(DataStoreEntryRef<ScriptStore> store) {
        return AppI18n.observable((String)"edit", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<ScriptStore> store) {
        return new LabelGraphic.IconGraphic("mdal-edit");
    }

    public Class<ScriptStore> getApplicableClass() {
        return ScriptStore.class;
    }

    public boolean isDefault() {
        return true;
    }

    public AbstractAction createAction(DataStoreEntryRef<ScriptStore> store) {
        return ((Action.ActionBuilder)Action.builder().ref(store)).build();
    }

    public String getId() {
        return "editScriptInEditor";
    }

    @JsonDeserialize(builder=ActionBuilderImpl.class)
    public static class Action
    extends StoreAction<ScriptStore> {
        public void executeImpl() {
            boolean predefined;
            boolean bl = predefined = DataStorage.get().getStoreCategoryIfPresent(this.ref.get().getCategoryUuid()).map(category -> category.getUuid().equals(DataStorage.PREDEFINED_SCRIPTS_CATEGORY_UUID)).orElse(false) != false && Arrays.stream(PredefinedScriptStore.values()).anyMatch(predefinedScriptStore -> predefinedScriptStore.getName().equals(this.ref.get().getName()));
            if (predefined) {
                StoreCreationDialog.showEdit((DataStoreEntry)this.ref.get());
                return;
            }
            boolean inPlace = ((ScriptStore)this.ref.getStore()).getTextSource() instanceof ScriptTextSource.InPlace;
            if (!inPlace) {
                StoreCreationDialog.showEdit((DataStoreEntry)this.ref.get());
                return;
            }
            ScriptStore script = (ScriptStore)this.ref.getStore();
            ShellDialect dialect = script.getShellDialect();
            String ext = dialect != null ? dialect.getScriptFileEnding() : "sh";
            String name = OsFileSystem.ofLocal().makeFileSystemCompatible(this.ref.get().getName());
            FileOpener.openString((String)(name + "." + ext), (Object)((Object)this), (String)script.getTextSource().getText().getValue(), s -> DataStorage.get().updateEntryStore(this.ref.get(), ((ScriptStore.ScriptStoreBuilder)script.toBuilder().textSource(ScriptTextSource.InPlace.builder().dialect(dialect).text(ShellScript.of((String)s)).build())).build()));
        }

        @Generated
        protected Action(ActionBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ActionBuilder<?, ?> builder() {
            return new ActionBuilderImpl();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ActionBuilderImpl
        extends ActionBuilder<Action, ActionBuilderImpl> {
            @Generated
            private ActionBuilderImpl() {
            }

            @Override
            @Generated
            protected ActionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Action build() {
                return new Action(this);
            }
        }

        @Generated
        public static abstract class ActionBuilder<C extends Action, B extends ActionBuilder<C, B>>
        extends StoreAction.StoreActionBuilder<ScriptStore, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ScriptQuickEditHubLeafProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

