/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.EnabledStoreState;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.ext.ValidatableStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.process.ScriptHelper;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.script.ScriptTextSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import lombok.Generated;

@JsonTypeName(value="script")
@JsonDeserialize(builder=ScriptStoreBuilderImpl.class)
public final class ScriptStore
implements SelfReferentialStore,
StatefulDataStore<EnabledStoreState>,
ValidatableStore {
    private final List<DataStoreEntryRef<ScriptStore>> scripts;
    private final String description;
    private final ScriptTextSource textSource;
    private final boolean initScript;
    private final boolean shellScript;
    private final boolean fileScript;
    private final boolean runnableScript;

    public Class<EnabledStoreState> getStateClass() {
        return EnabledStoreState.class;
    }

    SequencedCollection<DataStoreEntryRef<ScriptStore>> queryFlattenedScripts() {
        LinkedHashSet<DataStoreEntryRef<ScriptStore>> seen = new LinkedHashSet<DataStoreEntryRef<ScriptStore>>();
        this.queryFlattenedScripts(seen);
        return seen;
    }

    public ShellDialect getShellDialect() {
        return this.textSource != null ? this.textSource.getDialect() : null;
    }

    public boolean isCompatible(ShellControl shellControl) {
        ShellDialect targetType = shellControl.getOriginalShellDialect();
        return this.getShellDialect() == null || this.getShellDialect().isCompatibleTo(targetType);
    }

    public boolean isCompatible(ShellDialect dialect) {
        return this.getShellDialect() == null || this.getShellDialect().isCompatibleTo(dialect);
    }

    private String assembleScript(ShellControl shellControl, boolean args) {
        if (this.isCompatible(shellControl)) {
            String raw = this.getTextSource().getText().withoutShebang().getValue();
            if (raw.isBlank()) {
                return null;
            }
            ShellDialect targetType = shellControl.getOriginalShellDialect();
            ShellDialect scriptDialect = this.getShellDialect() != null ? this.getShellDialect() : targetType;
            FilePath script = ScriptHelper.createExecScript((ShellDialect)scriptDialect, (ShellControl)shellControl, (String)raw);
            boolean canSource = targetType.isSourceCompatibleTo(scriptDialect);
            String base = canSource ? targetType.sourceScriptCommand(shellControl, script.toString()) : targetType.runScriptCommand(shellControl, script.toString());
            return base + (String)(args ? " " + targetType.getCatchAllVariable() : "");
        }
        return null;
    }

    public ShellScript assembleScriptChain(ShellControl shellControl, boolean args) {
        SequencedCollection<DataStoreEntryRef<ScriptStore>> all = this.queryFlattenedScripts();
        for (DataStoreEntryRef dataStoreEntryRef : all) {
            ((ScriptStore)dataStoreEntryRef.getStore()).getTextSource().checkAvailable();
        }
        List<String> r = all.stream().map(ref -> ((ScriptStore)ref.getStore()).assembleScript(shellControl, args)).filter(s -> s != null).toList();
        if (r.isEmpty()) {
            return null;
        }
        return ShellScript.lines(r);
    }

    public ShellScript assembleScriptForFile(ShellControl shellControl) {
        String raw = this.getTextSource().getText().withoutShebang().getValue();
        if (raw.isBlank()) {
            return null;
        }
        ShellDialect targetType = shellControl.getOriginalShellDialect();
        ShellDialect scriptDialect = this.getShellDialect() != null ? this.getShellDialect() : targetType;
        String content = scriptDialect.prepareScriptContent(shellControl, raw);
        return ShellScript.of((String)content);
    }

    public void checkComplete() throws Throwable {
        if (this.textSource != null) {
            this.textSource.checkComplete();
        }
        if (!(this.initScript || this.shellScript || this.fileScript || this.runnableScript)) {
            throw new ValidationException(AppI18n.get((String)"valueMustNotBeEmpty", (Object[])new Object[0]));
        }
        if (this.scripts != null) {
            Validators.contentNonNull(this.scripts);
            for (DataStoreEntryRef<ScriptStore> script : this.scripts) {
                Validators.nonNull(script);
                Validators.isType(script, ScriptStore.class);
            }
        }
    }

    public void queryFlattenedScripts(LinkedHashSet<DataStoreEntryRef<ScriptStore>> all) {
        DataStoreEntryRef ref = this.getSelfEntry().ref();
        boolean added = all.add((DataStoreEntryRef<ScriptStore>)ref);
        if (added) {
            this.getEffectiveScripts().stream().filter(scriptStoreDataStoreEntryRef -> !all.contains(scriptStoreDataStoreEntryRef)).forEach(scriptStoreDataStoreEntryRef -> ((ScriptStore)scriptStoreDataStoreEntryRef.getStore()).queryFlattenedScripts(all));
            all.remove(ref);
            all.add((DataStoreEntryRef<ScriptStore>)ref);
        }
    }

    public List<DataStoreEntryRef<ScriptStore>> getEffectiveScripts() {
        return this.scripts != null ? this.scripts.stream().filter(Objects::nonNull).filter(ref -> ref.get().getValidity().isUsable()).toList() : List.of();
    }

    public ScriptTextSource getTextSource() {
        return this.textSource != null ? this.textSource : ScriptTextSource.InPlace.builder().build();
    }

    public void validate() throws Exception {
        this.getTextSource().validate();
    }

    @Generated
    protected ScriptStore(ScriptStoreBuilder<?, ?> b) {
        this.scripts = switch (b.scripts == null ? 0 : b.scripts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.scripts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DataStoreEntryRef<ScriptStore>>(b.scripts));
        };
        this.description = b.description;
        this.textSource = b.textSource;
        this.initScript = b.initScript;
        this.shellScript = b.shellScript;
        this.fileScript = b.fileScript;
        this.runnableScript = b.runnableScript;
    }

    @Generated
    public static ScriptStoreBuilder<?, ?> builder() {
        return new ScriptStoreBuilderImpl();
    }

    @Generated
    public ScriptStoreBuilder<?, ?> toBuilder() {
        return new ScriptStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public List<DataStoreEntryRef<ScriptStore>> getScripts() {
        return this.scripts;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isInitScript() {
        return this.initScript;
    }

    @Generated
    public boolean isShellScript() {
        return this.shellScript;
    }

    @Generated
    public boolean isFileScript() {
        return this.fileScript;
    }

    @Generated
    public boolean isRunnableScript() {
        return this.runnableScript;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptStore)) {
            return false;
        }
        ScriptStore other = (ScriptStore)o;
        if (this.isInitScript() != other.isInitScript()) {
            return false;
        }
        if (this.isShellScript() != other.isShellScript()) {
            return false;
        }
        if (this.isFileScript() != other.isFileScript()) {
            return false;
        }
        if (this.isRunnableScript() != other.isRunnableScript()) {
            return false;
        }
        List<DataStoreEntryRef<ScriptStore>> this$scripts = this.getScripts();
        List<DataStoreEntryRef<ScriptStore>> other$scripts = other.getScripts();
        if (this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ScriptTextSource this$textSource = this.getTextSource();
        ScriptTextSource other$textSource = other.getTextSource();
        return !(this$textSource == null ? other$textSource != null : !this$textSource.equals(other$textSource));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInitScript() ? 79 : 97);
        result = result * 59 + (this.isShellScript() ? 79 : 97);
        result = result * 59 + (this.isFileScript() ? 79 : 97);
        result = result * 59 + (this.isRunnableScript() ? 79 : 97);
        List<DataStoreEntryRef<ScriptStore>> $scripts = this.getScripts();
        result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ScriptTextSource $textSource = this.getTextSource();
        result = result * 59 + ($textSource == null ? 43 : $textSource.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScriptStore(scripts=" + String.valueOf(this.getScripts()) + ", description=" + this.getDescription() + ", textSource=" + String.valueOf(this.getTextSource()) + ", initScript=" + this.isInitScript() + ", shellScript=" + this.isShellScript() + ", fileScript=" + this.isFileScript() + ", runnableScript=" + this.isRunnableScript() + ")";
    }

    @Generated
    public static abstract class ScriptStoreBuilder<C extends ScriptStore, B extends ScriptStoreBuilder<C, B>> {
        @Generated
        private ArrayList<DataStoreEntryRef<ScriptStore>> scripts;
        @Generated
        private String description;
        @Generated
        private ScriptTextSource textSource;
        @Generated
        private boolean initScript;
        @Generated
        private boolean shellScript;
        @Generated
        private boolean fileScript;
        @Generated
        private boolean runnableScript;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ScriptStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ScriptStore instance, ScriptStoreBuilder<?, ?> b) {
            b.scripts(instance.scripts == null ? Collections.emptyList() : instance.scripts);
            b.description(instance.description);
            b.textSource(instance.textSource);
            b.initScript(instance.initScript);
            b.shellScript(instance.shellScript);
            b.fileScript(instance.fileScript);
            b.runnableScript(instance.runnableScript);
        }

        @Generated
        public B script(DataStoreEntryRef<ScriptStore> script) {
            if (this.scripts == null) {
                this.scripts = new ArrayList();
            }
            this.scripts.add(script);
            return this.self();
        }

        @Generated
        public B scripts(Collection<? extends DataStoreEntryRef<ScriptStore>> scripts) {
            if (scripts == null) {
                throw new NullPointerException("scripts cannot be null");
            }
            if (this.scripts == null) {
                this.scripts = new ArrayList();
            }
            this.scripts.addAll(scripts);
            return this.self();
        }

        @Generated
        public B clearScripts() {
            if (this.scripts != null) {
                this.scripts.clear();
            }
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B textSource(ScriptTextSource textSource) {
            this.textSource = textSource;
            return this.self();
        }

        @Generated
        public B initScript(boolean initScript) {
            this.initScript = initScript;
            return this.self();
        }

        @Generated
        public B shellScript(boolean shellScript) {
            this.shellScript = shellScript;
            return this.self();
        }

        @Generated
        public B fileScript(boolean fileScript) {
            this.fileScript = fileScript;
            return this.self();
        }

        @Generated
        public B runnableScript(boolean runnableScript) {
            this.runnableScript = runnableScript;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ScriptStore.ScriptStoreBuilder(scripts=" + String.valueOf(this.scripts) + ", description=" + this.description + ", textSource=" + String.valueOf(this.textSource) + ", initScript=" + this.initScript + ", shellScript=" + this.shellScript + ", fileScript=" + this.fileScript + ", runnableScript=" + this.runnableScript + ")";
        }
    }

    @JsonTypeName(value="script")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ScriptStoreBuilderImpl
    extends ScriptStoreBuilder<ScriptStore, ScriptStoreBuilderImpl> {
        @Generated
        private ScriptStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected ScriptStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ScriptStore build() {
            return new ScriptStore(this);
        }
    }
}

