/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public class ScriptStoreMigrationDeserializer
extends DelegatingDeserializer {
    public ScriptStoreMigrationDeserializer(JsonDeserializer<?> d) {
        super(d);
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new ScriptStoreMigrationDeserializer(newDelegatee);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return super.deserialize(this.restructure(p), ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws IOException {
        return super.deserialize(this.restructure(p), ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return super.deserializeWithType(this.restructure(jp), ctxt, typeDeserializer);
    }

    public JsonParser restructure(JsonParser p) throws IOException {
        TreeNode node = p.readValueAsTree();
        if (node == null || !node.isObject()) {
            return p;
        }
        if (node.get("textSource") == null) {
            this.migrate((ObjectNode)node);
        }
        TreeTraversingParser newJsonParser = new TreeTraversingParser((JsonNode)((ObjectNode)node), p.getCodec());
        newJsonParser.nextToken();
        return newJsonParser;
    }

    private void migrate(ObjectNode n) {
        JsonNode commandsNode = n.remove("commands");
        JsonNode dialectNode = n.remove("minimumDialect");
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.put("type", "inPlace");
        obj.put("text", commandsNode.textValue());
        if (!dialectNode.isNull()) {
            obj.put("dialect", dialectNode.textValue());
        } else {
            obj.putNull("dialect");
        }
        n.set("textSource", (JsonNode)obj);
    }
}

