/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.base.ListSelectorComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.EnabledStoreState;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellDialectIcons;
import io.xpipe.app.hub.comp.StoreEntryComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreListChoiceComp;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreToggleComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.platform.Validator;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptTextSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ScriptStoreProvider
implements DataStoreProvider {
    public StoreEntryComp customEntryComp(StoreSection sec, boolean preferLarge) {
        if (sec.getWrapper().getValidity().getValue() == DataStoreEntry.Validity.LOAD_FAILED) {
            return StoreEntryComp.create((StoreSection)sec, null, (boolean)preferLarge);
        }
        EnabledStoreState initialState = (EnabledStoreState)sec.getWrapper().getEntry().getStorePersistentState();
        SimpleBooleanProperty enabled = new SimpleBooleanProperty(initialState.isEnabled());
        sec.getWrapper().getPersistentState().subscribe(newValue -> {
            EnabledStoreState s = (EnabledStoreState)sec.getWrapper().getEntry().getStorePersistentState();
            enabled.set(s.isEnabled());
        });
        StoreToggleComp toggle = StoreToggleComp.enableToggle(null, (StoreSection)sec, (BooleanProperty)enabled, (s, aBoolean) -> {
            EnabledStoreState state = ((EnabledStoreState)s.getState()).toBuilder().enabled(aBoolean.booleanValue()).build();
            s.setState((DataStoreState)state);
        });
        return StoreEntryComp.create((StoreSection)sec, (BaseRegionBuilder)toggle, (boolean)preferLarge);
    }

    public DocumentationLink getHelpLink() {
        return DocumentationLink.SCRIPTING;
    }

    public boolean canMoveCategories() {
        return false;
    }

    public boolean showProviderChoice() {
        return false;
    }

    public boolean shouldShowScan() {
        return false;
    }

    public BaseRegionBuilder<?, ?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SCRIPT;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        ScriptStore st = (ScriptStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty textSource = new SimpleObjectProperty((Object)(st.getTextSource() != null ? st.getTextSource() : ScriptTextSource.InPlace.builder().build()));
        SimpleListProperty others = new SimpleListProperty(FXCollections.observableArrayList(new ArrayList<DataStoreEntryRef<ScriptStore>>(st.getEffectiveScripts())));
        OptionsChoiceBuilder textSourceChoice = OptionsChoiceBuilder.builder().property((Property)textSource).available(ScriptTextSource.getClasses()).allowNull(true).build();
        List<Integer> vals = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        ArrayList<Integer> selectedStart = new ArrayList<Integer>();
        if (st.isInitScript()) {
            selectedStart.add(0);
        }
        if (st.isRunnableScript()) {
            selectedStart.add(1);
        }
        if (st.isFileScript()) {
            selectedStart.add(2);
        }
        if (st.isShellScript()) {
            selectedStart.add(3);
        }
        Function<Integer, String> name = new Function<Integer, String>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public String apply(Integer integer) {
                if (integer == 0) {
                    return AppI18n.get((String)"initScript", (Object[])new Object[0]);
                }
                if (integer == 1) {
                    return AppI18n.get((String)"runnableScript", (Object[])new Object[0]);
                }
                if (integer == 2) {
                    return AppI18n.get((String)"fileScript", (Object[])new Object[0]);
                }
                if (integer == 3) {
                    return AppI18n.get((String)"shellScript", (Object[])new Object[0]);
                }
                return "?";
            }
        };
        SimpleListProperty selectedExecTypes = new SimpleListProperty(FXCollections.observableList(selectedStart));
        ListSelectorComp selectorComp = new ListSelectorComp(FXCollections.observableList(vals), (Function)name, ignored -> null, (ObservableList)selectedExecTypes, v -> false, () -> false);
        return new OptionsBuilder().nameAndDescription("scriptSourceType").sub(textSourceChoice.build(), (Property)textSource).nameAndDescription("executionType").documentationLink(DocumentationLink.SCRIPTING_TYPES).addComp((BaseRegionBuilder)selectorComp, (Property)selectedExecTypes).check(validator -> Validator.nonEmpty((Validator)validator, (ObservableValue)AppI18n.observable((String)"executionType", (Object[])new Object[0]), (ReadOnlyListProperty)selectedExecTypes)).name("snippets").description("snippetsDescription").documentationLink(DocumentationLink.SCRIPTING_DEPENDENCIES).addComp((BaseRegionBuilder)new StoreListChoiceComp((ListProperty)others, ScriptStore.class, scriptStore -> !scriptStore.get().equals((Object)entry) && !others.contains(scriptStore), StoreViewState.get().getAllScriptsCategory()), (Property)others).bind(() -> ((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().textSource((ScriptTextSource)textSource.get())).scripts(new ArrayList(others.get()))).description(st.getDescription())).initScript(selectedExecTypes.contains((Object)0))).runnableScript(selectedExecTypes.contains((Object)1))).fileScript(selectedExecTypes.contains((Object)2))).shellScript(selectedExecTypes.contains((Object)3))).build(), new Property[]{store}).buildDialog();
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        ScriptStore st = (ScriptStore)wrapper.getEntry().getStore().asNeeded();
        String name = st.getShellDialect() != null ? st.getShellDialect().getExecutableName() : AppI18n.get((String)"generic", (Object[])new Object[0]);
        return name + " " + AppI18n.get((String)"script", (Object[])new Object[0]);
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ScriptStore st = (ScriptStore)section.getWrapper().getEntry().getStore().asNeeded();
        String init = st.isInitScript() ? AppI18n.get((String)"init", (Object[])new Object[0]) : null;
        String file = st.isFileScript() ? AppI18n.get((String)"fileBrowser", (Object[])new Object[0]) : null;
        String shell = st.isShellScript() ? AppI18n.get((String)"shell", (Object[])new Object[0]) : null;
        String name = st.isShellScript() ? (String)this.getShellSessionScriptName(section.getWrapper()).orElse(null) : null;
        String runnable = st.isRunnableScript() ? AppI18n.get((String)"hub", (Object[])new Object[0]) : null;
        return new ReadOnlyObjectWrapper((Object)new StoreStateFormat(List.of(), st.getTextSource().toSummary(), new String[]{shell, init, file, runnable, name}).format());
    }

    private Optional<String> getShellSessionScriptName(StoreEntryWrapper wrapper) {
        ScriptStore st = (ScriptStore)wrapper.getEntry().getStore().asNeeded();
        if (!st.isShellScript()) {
            return Optional.empty();
        }
        String name = ((String)wrapper.getName().getValue()).toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        if (st.getShellDialect() == null) {
            return Optional.of(OsFileSystem.of((OsType.Any)OsType.LINUX).makeFileSystemCompatible(name) + ".sh");
        }
        OsType.Windows os = st.getShellDialect() == ShellDialects.CMD || ShellDialects.isPowershell((ShellDialect)st.getShellDialect()) ? OsType.WINDOWS : OsType.LINUX;
        return Optional.of(OsFileSystem.of((OsType.Any)os).makeFileSystemCompatible(name) + "." + st.getShellDialect().getScriptFileEnding());
    }

    public String getDisplayIconFileName(DataStore store) {
        if (store == null) {
            return "base:script_icon.svg";
        }
        ScriptStore st = (ScriptStore)store.asNeeded();
        return ShellDialectIcons.getImageName((ShellDialect)st.getShellDialect());
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((ScriptStore.ScriptStoreBuilder)ScriptStore.builder().scripts(List.of())).build();
    }

    public String getId() {
        return "script";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(ScriptStore.class);
    }
}

