/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.EnabledStoreState;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.process.ShellTemp;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;

public class ScriptStoreSetup {
    public static void controlWithDefaultScripts(ShellControl pc) {
        ScriptStoreSetup.controlWithScripts(pc, ScriptStoreSetup.getEnabledScripts(), false);
    }

    public static void controlWithScripts(ShellControl pc, Collection<DataStoreEntryRef<ScriptStore>> enabledScripts, boolean append) {
        try {
            StatefulDataStore sds;
            DataStoreState state;
            Object t;
            Optional source;
            ShellDialect dialect = pc.getShellDialect();
            if (dialect == null && (source = pc.getSourceStore()).isPresent() && (t = source.get()) instanceof StatefulDataStore && (state = (sds = (StatefulDataStore)t).getState()) instanceof SystemState) {
                SystemState systemState = (SystemState)state;
                dialect = systemState.getShellDialect();
            }
            ShellDialect finalDialect = dialect;
            SequencedCollection<Object> initFlattened = ScriptStoreSetup.flatten(enabledScripts).stream().filter(store -> ((ScriptStore)store.getStore()).isInitScript()).filter(store -> finalDialect == null || ((ScriptStore)store.getStore()).isCompatible(finalDialect)).toList();
            if (!append) {
                initFlattened = initFlattened.reversed();
            }
            SequencedCollection<Object> bringFlattened = ScriptStoreSetup.flatten(enabledScripts).stream().filter(store -> ((ScriptStore)store.getStore()).isShellScript()).filter(store -> finalDialect == null || ((ScriptStore)store.getStore()).isCompatible(finalDialect)).toList();
            if (!append) {
                bringFlattened = bringFlattened.reversed();
            }
            if (initFlattened.isEmpty() && bringFlattened.isEmpty()) {
                return;
            }
            initFlattened.forEach(s -> pc.withInitSnippet(new ShellTerminalInitCommand((DataStoreEntryRef)s){
                final /* synthetic */ DataStoreEntryRef val$s;
                {
                    this.val$s = dataStoreEntryRef;
                }

                public Optional<String> terminalContent(ShellControl shellControl) {
                    ShellScript assembled = ((ScriptStore)this.val$s.getStore()).assembleScriptChain(shellControl, false);
                    if (assembled == null) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(assembled.getValue());
                }

                public boolean canPotentiallyRunInDialect(ShellDialect dialect) {
                    return ((ScriptStore)this.val$s.getStore()).isCompatible(dialect);
                }
            }, append));
            if (!bringFlattened.isEmpty()) {
                SequencedCollection<Object> finalBringFlattened = bringFlattened;
                pc.withInitSnippet(new ShellTerminalInitCommand((List)finalBringFlattened){
                    FilePath dir;
                    final /* synthetic */ List val$finalBringFlattened;
                    {
                        this.val$finalBringFlattened = list;
                    }

                    public Optional<String> terminalContent(ShellControl shellControl) throws Exception {
                        if (this.dir == null) {
                            this.dir = ScriptStoreSetup.initScriptsDirectory(shellControl, this.val$finalBringFlattened);
                        }
                        if (this.dir == null) {
                            return Optional.empty();
                        }
                        return Optional.ofNullable(shellControl.getShellDialect().addToPathVariableCommand(List.of(this.dir.toString()), true));
                    }

                    public boolean canPotentiallyRunInDialect(ShellDialect dialect) {
                        return true;
                    }
                }, append);
            }
        }
        catch (StackOverflowError t) {
            throw (RuntimeException)ErrorEventFactory.expected((Throwable)new RuntimeException("Unable to set up scripts. Is there a circular script dependency?", t));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set up scripts", t);
        }
    }

    private static FilePath initScriptsDirectory(ShellControl sc, List<DataStoreEntryRef<ScriptStore>> refs) {
        if (refs.isEmpty()) {
            return null;
        }
        List<DataStoreEntryRef> applicable = refs.stream().filter(ss -> ((ScriptStore)ss.getStore()).isCompatible(sc.getShellDialect())).toList();
        if (applicable.isEmpty()) {
            return null;
        }
        int hash = refs.stream().mapToInt(value -> value.get().getName().hashCode() + ((ScriptStore)value.getStore()).hashCode()).sum();
        FilePath targetDir = ShellTemp.createUserSpecificTempDataDirectory((ShellControl)sc, (String)"scripts").join(new String[]{sc.getShellDialect().getId()});
        FilePath hashFile = targetDir.join(new String[]{"hash"});
        if (sc.view().fileExists(hashFile)) {
            String read = sc.view().readTextFile(hashFile);
            try {
                int readHash = Integer.parseInt(read.strip());
                if (hash == readHash) {
                    return targetDir;
                }
            }
            catch (NumberFormatException e) {
                ErrorEventFactory.fromThrowable((Throwable)e).expected().omit().handle();
            }
        }
        if (sc.view().directoryExists(targetDir)) {
            sc.view().deleteDirectory(targetDir);
        }
        sc.view().mkdir(targetDir);
        ArrayList<DataStoreEntryRef<ScriptStore>> availableRefs = new ArrayList<DataStoreEntryRef<ScriptStore>>(refs);
        availableRefs.removeIf(ref -> {
            try {
                ((ScriptStore)ref.getStore()).getTextSource().checkAvailable();
                return false;
            }
            catch (Exception ex) {
                ErrorEventFactory.fromThrowable((Throwable)ex).expected().handle();
                return true;
            }
        });
        ShellDialect d = sc.getShellDialect();
        for (DataStoreEntryRef<ScriptStore> scriptStore : availableRefs) {
            ShellScript content = ((ScriptStore)scriptStore.getStore()).assembleScriptForFile(sc);
            if (content == null) continue;
            String fileName = OsFileSystem.of((OsType.Any)sc.getOsType()).makeFileSystemCompatible(scriptStore.get().getName().toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
            String fileType = ((ScriptStore)scriptStore.getStore()).getShellDialect() != null ? ((ScriptStore)scriptStore.getStore()).getShellDialect().getScriptFileEnding() : d.getScriptFileEnding();
            FilePath scriptFile = targetDir.join(new String[]{fileName + "." + fileType});
            sc.view().writeScriptFile(scriptFile, content.getValue());
        }
        sc.view().writeTextFile(hashFile, String.valueOf(hash));
        return targetDir;
    }

    public static List<DataStoreEntryRef<ScriptStore>> getEnabledScripts() {
        List<DataStoreEntryRef<ScriptStore>> l = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> {
            ScriptStore ss;
            DataStore patt0$temp;
            return dataStoreEntry.getValidity().isUsable() && (patt0$temp = dataStoreEntry.getStore()) instanceof ScriptStore && ((EnabledStoreState)(ss = (ScriptStore)patt0$temp).getState()).isEnabled();
        }).map(DataStoreEntry::ref).toList();
        return l;
    }

    public static List<DataStoreEntryRef<ScriptStore>> flatten(Collection<DataStoreEntryRef<ScriptStore>> scripts) {
        LinkedHashSet seen = new LinkedHashSet();
        scripts.stream().filter(scriptStoreDataStoreEntryRef -> scriptStoreDataStoreEntryRef.get().getValidity().isUsable()).forEach(scriptStoreDataStoreEntryRef -> ((ScriptStore)scriptStoreDataStoreEntryRef.getStore()).queryFlattenedScripts(seen));
        HashMap dependencies = new HashMap();
        seen.forEach(ref -> {
            HashSet<DataStoreEntryRef<ScriptStore>> f = new HashSet<DataStoreEntryRef<ScriptStore>>(((ScriptStore)ref.getStore()).queryFlattenedScripts());
            f.remove(ref);
            dependencies.put(ref, f);
        });
        ArrayList<DataStoreEntryRef<ScriptStore>> sorted = new ArrayList<DataStoreEntryRef<ScriptStore>>(seen);
        sorted.sort((o1, o2) -> {
            if (((Set)dependencies.get(o1)).contains(o2)) {
                return 1;
            }
            if (((Set)dependencies.get(o2)).contains(o1)) {
                return -1;
            }
            return 0;
        });
        return sorted;
    }
}

