/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.InputGroupComp;
import io.xpipe.app.comp.base.IntegratedTextAreaComp;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.window.AppDialog;
import io.xpipe.app.ext.ShellDialectChoiceComp;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.HttpHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.UuidHelper;
import io.xpipe.ext.base.script.ScriptCollectionSourceEntry;
import io.xpipe.ext.base.script.ScriptCollectionSourceImportDialog;
import io.xpipe.ext.base.script.ScriptCollectionSourceStore;
import io.xpipe.ext.base.script.ScriptDialects;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InPlace.class), @JsonSubTypes.Type(value=SourceReference.class), @JsonSubTypes.Type(value=Url.class)})
public interface ScriptTextSource {
    public void checkComplete() throws ValidationException;

    public void checkAvailable();

    public void validate() throws Exception;

    public String toSummary();

    public ShellDialect getDialect();

    public ShellScript getText();

    public static List<Class<?>> getClasses() {
        ArrayList l = new ArrayList();
        l.add(InPlace.class);
        l.add(SourceReference.class);
        l.add(Url.class);
        return l;
    }

    @JsonTypeName(value="inPlace")
    @JsonDeserialize(builder=InPlaceBuilder.class)
    public static final class InPlace
    implements ScriptTextSource {
        private final ShellDialect dialect;
        private final ShellScript text;

        public static String getOptionsNameKey() {
            return "scriptSourceTypeInPlace";
        }

        static OptionsBuilder createOptions(Property<InPlace> property) {
            SimpleObjectProperty dialect = new SimpleObjectProperty((Object)((InPlace)property.getValue()).getDialect());
            SimpleObjectProperty text = new SimpleObjectProperty((Object)((InPlace)property.getValue()).getText());
            List<ShellDialect> availableDialects = ScriptDialects.getSupported();
            ShellDialectChoiceComp choice = new ShellDialectChoiceComp(availableDialects, (Property)dialect, ShellDialectChoiceComp.NullHandling.NULL_IS_ALL);
            return new OptionsBuilder().name("minimumShellDialect").description("minimumShellDialectDescription").documentationLink(DocumentationLink.SCRIPTING_COMPATIBILITY).addComp((BaseRegionBuilder)choice, (Property)dialect).name("scriptContents").description("scriptContentsDescription").documentationLink(DocumentationLink.SCRIPTING_EDITING).addComp((BaseRegionBuilder)IntegratedTextAreaComp.script((Property)text, (ObservableValue)Bindings.createStringBinding(() -> dialect.getValue() != null ? ((ShellDialect)dialect.getValue()).getScriptFileEnding() : "sh", (Observable[])new Observable[]{dialect})), (Property)text).bind(() -> InPlace.builder().dialect((ShellDialect)dialect.get()).text((ShellScript)text.get()).build(), new Property[]{property});
        }

        @Override
        public void checkComplete() {
        }

        @Override
        public void checkAvailable() {
        }

        @Override
        public void validate() {
            this.checkAvailable();
        }

        @Override
        public String toSummary() {
            return AppI18n.get((String)"inPlaceScript", (Object[])new Object[0]);
        }

        @Override
        public ShellScript getText() {
            return this.text != null ? this.text : ShellScript.empty();
        }

        @Generated
        InPlace(ShellDialect dialect, ShellScript text) {
            this.dialect = dialect;
            this.text = text;
        }

        @Generated
        public static InPlaceBuilder builder() {
            return new InPlaceBuilder();
        }

        @Override
        @Generated
        public ShellDialect getDialect() {
            return this.dialect;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InPlace)) {
                return false;
            }
            InPlace other = (InPlace)o;
            ShellDialect this$dialect = this.getDialect();
            ShellDialect other$dialect = other.getDialect();
            if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
                return false;
            }
            ShellScript this$text = this.getText();
            ShellScript other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ShellDialect $dialect = this.getDialect();
            result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
            ShellScript $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScriptTextSource.InPlace(dialect=" + String.valueOf(this.getDialect()) + ", text=" + String.valueOf(this.getText()) + ")";
        }

        @JsonTypeName(value="inPlace")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class InPlaceBuilder {
            @Generated
            private ShellDialect dialect;
            @Generated
            private ShellScript text;

            @Generated
            InPlaceBuilder() {
            }

            @Generated
            public InPlaceBuilder dialect(ShellDialect dialect) {
                this.dialect = dialect;
                return this;
            }

            @Generated
            public InPlaceBuilder text(ShellScript text) {
                this.text = text;
                return this;
            }

            @Generated
            public InPlace build() {
                return new InPlace(this.dialect, this.text);
            }

            @Generated
            public String toString() {
                return "ScriptTextSource.InPlace.InPlaceBuilder(dialect=" + String.valueOf(this.dialect) + ", text=" + String.valueOf(this.text) + ")";
            }
        }
    }

    @JsonTypeName(value="source")
    @JsonDeserialize(builder=SourceReferenceBuilder.class)
    public static final class SourceReference
    implements ScriptTextSource {
        private final DataStoreEntryRef<ScriptCollectionSourceStore> ref;
        private final String name;

        public static String getOptionsNameKey() {
            return "scriptSourceTypeSource";
        }

        static OptionsBuilder createOptions(Property<SourceReference> property) {
            SimpleObjectProperty ref = new SimpleObjectProperty(((SourceReference)property.getValue()).getRef());
            SimpleStringProperty name = new SimpleStringProperty(((SourceReference)property.getValue()).getName());
            StoreChoiceComp sourceChoice = new StoreChoiceComp(null, (ObjectProperty)ref, ScriptCollectionSourceStore.class, ignored -> true, StoreViewState.get().getAllScriptsCategory(), StoreViewState.get().getScriptSourcesCategory(), true);
            ButtonComp importButton = new ButtonComp(null, (LabelGraphic)new LabelGraphic.IconGraphic("mdi2i-import"), () -> {
                Optional current = AppDialog.getCurrentModalOverlay();
                current.ifPresent(modalOverlay -> modalOverlay.close());
                ScriptCollectionSourceImportDialog dialog = new ScriptCollectionSourceImportDialog((DataStoreEntryRef<ScriptCollectionSourceStore>)((DataStoreEntryRef)ref.get()));
                dialog.show();
            });
            importButton.disable((ObservableValue)ref.isNull());
            return new OptionsBuilder().nameAndDescription("scriptCollectionSourceEntry").addComp((BaseRegionBuilder)new InputGroupComp(List.of(sourceChoice, importButton)).setMainReference(0), (Property)ref).nonNull().nameAndDescription("scriptSourceName").addString((Property)name).nonNull().bind(() -> SourceReference.builder().ref((DataStoreEntryRef<ScriptCollectionSourceStore>)((DataStoreEntryRef)ref.getValue())).name(name.getValue()).build(), new Property[]{property});
        }

        @Override
        public void checkComplete() {
            Validators.nonNull(this.ref);
            this.ref.checkComplete();
        }

        @Override
        public void checkAvailable() {
            List<ScriptCollectionSourceEntry> cached = ((ScriptCollectionSourceStore.State)((ScriptCollectionSourceStore)this.ref.getStore()).getState()).getEntries();
            if (cached == null) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Source " + this.ref.get().getName() + " has not been initialized"));
            }
            ScriptCollectionSourceEntry found = cached.stream().filter(e -> e.getName().equals(this.name)).findFirst().orElse(null);
            if (found == null) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Script file " + this.name + " not found in local cache for source " + this.ref.get().getName()));
            }
            if (!Files.exists(found.getLocalFile(), new LinkOption[0])) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Referenced script file " + String.valueOf(found.getLocalFile()) + " does not exist"));
            }
        }

        @Override
        public void validate() {
            this.checkAvailable();
        }

        @Override
        public String toSummary() {
            return AppI18n.get((String)"sourcedFrom", (Object[])new Object[]{this.ref.get().getName()});
        }

        @Override
        public ShellDialect getDialect() {
            ScriptCollectionSourceEntry found = this.findSourceEntryIfPossible();
            return found != null ? found.getDialect() : null;
        }

        @Override
        public ShellScript getText() {
            ScriptCollectionSourceEntry found = this.findSourceEntryIfPossible();
            if (found == null) {
                return ShellScript.empty();
            }
            if (!Files.exists(found.getLocalFile(), new LinkOption[0])) {
                return ShellScript.empty();
            }
            try {
                String r = Files.readString(found.getLocalFile());
                return ShellScript.of((String)r);
            }
            catch (IOException e) {
                ErrorEventFactory.fromThrowable((Throwable)e).expected().handle();
                return ShellScript.empty();
            }
        }

        private ScriptCollectionSourceEntry findSourceEntryIfPossible() {
            if (this.ref == null) {
                return null;
            }
            List<ScriptCollectionSourceEntry> cached = ((ScriptCollectionSourceStore.State)((ScriptCollectionSourceStore)this.ref.getStore()).getState()).getEntries();
            if (cached == null) {
                return null;
            }
            ScriptCollectionSourceEntry found = cached.stream().filter(e -> e.getName().equals(this.name)).findFirst().orElse(null);
            if (found == null) {
                return null;
            }
            return found;
        }

        @Generated
        SourceReference(DataStoreEntryRef<ScriptCollectionSourceStore> ref, String name) {
            this.ref = ref;
            this.name = name;
        }

        @Generated
        public static SourceReferenceBuilder builder() {
            return new SourceReferenceBuilder();
        }

        @Generated
        public DataStoreEntryRef<ScriptCollectionSourceStore> getRef() {
            return this.ref;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceReference)) {
                return false;
            }
            SourceReference other = (SourceReference)o;
            DataStoreEntryRef<ScriptCollectionSourceStore> this$ref = this.getRef();
            DataStoreEntryRef<ScriptCollectionSourceStore> other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataStoreEntryRef<ScriptCollectionSourceStore> $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScriptTextSource.SourceReference(ref=" + String.valueOf(this.getRef()) + ", name=" + this.getName() + ")";
        }

        @JsonTypeName(value="source")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class SourceReferenceBuilder {
            @Generated
            private DataStoreEntryRef<ScriptCollectionSourceStore> ref;
            @Generated
            private String name;

            @Generated
            SourceReferenceBuilder() {
            }

            @Generated
            public SourceReferenceBuilder ref(DataStoreEntryRef<ScriptCollectionSourceStore> ref) {
                this.ref = ref;
                return this;
            }

            @Generated
            public SourceReferenceBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public SourceReference build() {
                return new SourceReference(this.ref, this.name);
            }

            @Generated
            public String toString() {
                return "ScriptTextSource.SourceReference.SourceReferenceBuilder(ref=" + String.valueOf(this.ref) + ", name=" + this.name + ")";
            }
        }
    }

    @JsonTypeName(value="url")
    @JsonDeserialize(builder=UrlBuilder.class)
    public static final class Url
    implements ScriptTextSource {
        private final ShellDialect dialect;
        private final String url;

        public static String getOptionsNameKey() {
            return "scriptSourceTypeUrl";
        }

        static OptionsBuilder createOptions(Property<Url> property) {
            SimpleObjectProperty dialect = new SimpleObjectProperty((Object)((Url)property.getValue()).getDialect());
            SimpleStringProperty url = new SimpleStringProperty(((Url)property.getValue()).getUrl());
            List<ShellDialect> availableDialects = ScriptDialects.getSupported();
            ShellDialectChoiceComp choice = new ShellDialectChoiceComp(availableDialects, (Property)dialect, ShellDialectChoiceComp.NullHandling.NULL_IS_ALL);
            return new OptionsBuilder().name("minimumShellDialect").description("minimumShellDialectDescription").documentationLink(DocumentationLink.SCRIPTING_COMPATIBILITY).addComp((BaseRegionBuilder)choice, (Property)dialect).nameAndDescription("scriptTextSourceUrl").addString((Property)url).nonNull().bind(() -> Url.builder().dialect((ShellDialect)dialect.get()).url(url.get()).build(), new Property[]{property});
        }

        public void refresh() throws Exception {
            Path path = this.getLocalPath();
            if (Files.exists(path, new LinkOption[0])) {
                return;
            }
            HttpRequest req = HttpRequest.newBuilder().GET().uri(URI.create(this.url)).build();
            HttpResponse<String> r = HttpHelper.client().send(req, HttpResponse.BodyHandlers.ofString());
            if (r.statusCode() >= 400) {
                throw (IOException)ErrorEventFactory.expected((Throwable)new IOException(r.body()));
            }
            Files.writeString(path, (CharSequence)r.body(), new OpenOption[0]);
        }

        private Path getLocalPath() {
            return AppCache.getBasePath().resolve("scripts").resolve(this.getName());
        }

        private String getName() {
            String name = FilePath.of((String)this.url).getFileName();
            if (!name.isEmpty()) {
                return name;
            }
            return UuidHelper.generateFromObject((Object[])new Object[]{this.url}).toString();
        }

        @Override
        public void checkComplete() throws ValidationException {
            Validators.nonNull((Object)this.url);
        }

        @Override
        public void checkAvailable() {
            if (!Files.exists(this.getLocalPath(), new LinkOption[0])) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Script URL " + this.url + " has not been initialized"));
            }
        }

        @Override
        public void validate() throws Exception {
            this.refresh();
            this.checkAvailable();
        }

        @Override
        public String toSummary() {
            return AppI18n.get((String)"sourcedFrom", (Object[])new Object[]{this.url.replace("http://", "").replace("https://", "").replace("file://", "").replace("ssh://", "")});
        }

        @Override
        public ShellScript getText() {
            Path path = this.getLocalPath();
            if (!Files.exists(path, new LinkOption[0])) {
                return ShellScript.empty();
            }
            try {
                String r = Files.readString(path);
                return ShellScript.of((String)r);
            }
            catch (IOException e) {
                ErrorEventFactory.fromThrowable((Throwable)e).expected().handle();
                return ShellScript.empty();
            }
        }

        @Generated
        Url(ShellDialect dialect, String url) {
            this.dialect = dialect;
            this.url = url;
        }

        @Generated
        public static UrlBuilder builder() {
            return new UrlBuilder();
        }

        @Override
        @Generated
        public ShellDialect getDialect() {
            return this.dialect;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Url)) {
                return false;
            }
            Url other = (Url)o;
            ShellDialect this$dialect = this.getDialect();
            ShellDialect other$dialect = other.getDialect();
            if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ShellDialect $dialect = this.getDialect();
            result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScriptTextSource.Url(dialect=" + String.valueOf(this.getDialect()) + ", url=" + this.getUrl() + ")";
        }

        @JsonTypeName(value="url")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class UrlBuilder {
            @Generated
            private ShellDialect dialect;
            @Generated
            private String url;

            @Generated
            UrlBuilder() {
            }

            @Generated
            public UrlBuilder dialect(ShellDialect dialect) {
                this.dialect = dialect;
                return this;
            }

            @Generated
            public UrlBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public Url build() {
                return new Url(this.dialect, this.url);
            }

            @Generated
            public String toString() {
                return "ScriptTextSource.Url.UrlBuilder(dialect=" + String.valueOf(this.dialect) + ", url=" + this.url + ")";
            }
        }
    }
}

