/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.StartOnInitStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.base.service.ServiceAddressRotation;
import io.xpipe.ext.base.service.ServiceProtocolType;
import lombok.Generated;

public abstract class AbstractServiceStore
implements SingletonSessionStore<NetworkTunnelSession>,
DataStore,
StartOnInitStore {
    private final Integer remotePort;
    private final Integer localPort;
    private final ServiceProtocolType serviceProtocolType;

    public abstract boolean shouldTunnel();

    public abstract String getAddress();

    public abstract DataStoreEntryRef<NetworkTunnelStore> getGateway();

    public abstract DataStoreEntryRef<HostAddressStore> getHost();

    public boolean licenseRequired() {
        return true;
    }

    public boolean canAutomaticallyStart() {
        return this.requiresTunnel();
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull((Object)this.remotePort);
        Validators.nonNull((Object)this.serviceProtocolType);
        if (this.getHost() == null) {
            Validators.nonNull((Object)this.getAddress());
        }
    }

    public String getOpenTargetUrl() {
        NetworkTunnelSession s = (NetworkTunnelSession)this.getSession();
        if (s == null) {
            DataStore dataStore;
            String address = this.getAddress();
            if (address == null && (dataStore = this.getHost().getStore()) instanceof HostAddressGatewayStore) {
                HostAddressGatewayStore g = (HostAddressGatewayStore)dataStore;
                if (!(this.getHost().getStore() instanceof NetworkTunnelStore)) {
                    address = g.getHostAddress().get();
                }
            }
            if (address == null && (dataStore = this.getHost().getStore()) instanceof NetworkTunnelStore) {
                NetworkTunnelStore t = (NetworkTunnelStore)dataStore;
                HostAddress h = t.getTunnelHostName();
                String string = address = !h.isEmpty() ? h.get() : null;
            }
            if (address == null) {
                address = "localhost";
            }
            return ServiceAddressRotation.getRotatedLocalhost(address + ":" + this.getRemotePort());
        }
        return ServiceAddressRotation.getRotatedLocalhost("localhost:" + s.getLocalPort());
    }

    public boolean requiresTunnel() {
        DataStoreEntryRef<NetworkTunnelStore> gw;
        if (this.getAddress() != null) {
            DataStoreEntryRef<NetworkTunnelStore> gateway = this.getGateway();
            if (gateway != null) {
                return ((NetworkTunnelStore)gateway.getStore()).requiresTunnel();
            }
            return false;
        }
        if (this.getHost() == null) {
            return false;
        }
        DataStore dataStore = this.getHost().getStore();
        if (dataStore instanceof HostAddressGatewayStore) {
            HostAddressGatewayStore g = (HostAddressGatewayStore)dataStore;
            if (!(this.getHost().getStore() instanceof NetworkTunnelStore)) {
                gw = g.getTunnelGateway();
                return gw != null && ((NetworkTunnelStore)gw.getStore()).requiresTunnel();
            }
        }
        if (!((gw = this.getHost().getStore()) instanceof NetworkTunnelStore)) {
            return false;
        }
        NetworkTunnelStore t = (NetworkTunnelStore)gw;
        if (!t.isLocallyTunnelable()) {
            DataStore dataStore2;
            DataStoreEntryRef parent = t.getNetworkParent();
            if (parent == null || !((dataStore2 = parent.getStore()) instanceof NetworkTunnelStore)) {
                return false;
            }
            NetworkTunnelStore nts = (NetworkTunnelStore)dataStore2;
            return this.shouldTunnel() && nts.requiresTunnel();
        }
        return this.shouldTunnel() && t.requiresTunnel();
    }

    public NetworkTunnelSession newSession() {
        int l;
        long active;
        if (!(this.getAddress() == null || this.getGateway() != null && ((NetworkTunnelStore)this.getGateway().getStore()).isLocallyTunnelable())) {
            return null;
        }
        if (this.getHost() != null) {
            DataStore dataStore;
            if (!(this.getHost().getStore() instanceof NetworkTunnelStore) && (dataStore = this.getHost().getStore()) instanceof HostAddressGatewayStore) {
                HostAddressGatewayStore g = (HostAddressGatewayStore)dataStore;
                if (g.getTunnelGateway() == null || !((NetworkTunnelStore)g.getTunnelGateway().getStore()).requiresTunnel() || !((NetworkTunnelStore)g.getTunnelGateway().getStore()).isLocallyTunnelable()) {
                    return null;
                }
            } else {
                dataStore = this.getHost().getStore();
                if (dataStore instanceof NetworkTunnelStore) {
                    DataStoreEntryRef parent;
                    NetworkTunnelStore t = (NetworkTunnelStore)dataStore;
                    if (!t.isLocallyTunnelable() && !((parent = t.getNetworkParent()).getStore() instanceof NetworkTunnelStore)) {
                        return null;
                    }
                    if (!this.shouldTunnel()) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
        }
        LicensedFeature f = LicenseProvider.get().getFeature("services");
        if (this.licenseRequired() && !f.isSupported() && (active = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> {
            AbstractServiceStore a;
            DataStore patt0$temp = dataStoreEntry.getStore();
            return patt0$temp instanceof AbstractServiceStore && (a = (AbstractServiceStore)patt0$temp) != this && a.licenseRequired() && a.isSessionRunning();
        }).count()) > 0L) {
            f.throwIfUnsupported();
        }
        int n = l = this.localPort != null ? this.localPort : HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        if (this.getAddress() != null) {
            DataStoreEntryRef<NetworkTunnelStore> gateway = this.getGateway();
            return ((NetworkTunnelStore)gateway.getStore()).createTunnelSession(l, this.remotePort.intValue(), this.getAddress());
        }
        DataStore dataStore = this.getHost().getStore();
        if (dataStore instanceof NetworkTunnelStore) {
            DataStore dataStore2;
            NetworkTunnelStore t = (NetworkTunnelStore)dataStore;
            DataStoreEntryRef parent = t.getNetworkParent();
            if (!t.isLocallyTunnelable() && (dataStore2 = parent.getStore()) instanceof NetworkTunnelStore) {
                NetworkTunnelStore nts = (NetworkTunnelStore)dataStore2;
                ((HostAddressStore)this.getHost().getStore()).refreshHostAddressOrThrow();
                HostAddress h = t.getTunnelHostName();
                return nts.createTunnelSession(l, this.remotePort.intValue(), !h.isEmpty() ? h.get() : "localhost");
            }
            return t.createTunnelSession(l, this.remotePort.intValue(), "localhost");
        }
        HostAddressGatewayStore g = (HostAddressGatewayStore)this.getHost().getStore();
        return ((NetworkTunnelStore)g.getTunnelGateway().getStore()).createTunnelSession(l, this.remotePort.intValue(), g.getHostAddress().get());
    }

    public Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    public void startOnInit() throws Exception {
        this.startSessionIfNeeded();
    }

    @Generated
    protected AbstractServiceStore(AbstractServiceStoreBuilder<?, ?> b) {
        this.remotePort = b.remotePort;
        this.localPort = b.localPort;
        this.serviceProtocolType = b.serviceProtocolType;
    }

    @Generated
    public Integer getRemotePort() {
        return this.remotePort;
    }

    @Generated
    public Integer getLocalPort() {
        return this.localPort;
    }

    @Generated
    public ServiceProtocolType getServiceProtocolType() {
        return this.serviceProtocolType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractServiceStore)) {
            return false;
        }
        AbstractServiceStore other = (AbstractServiceStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$remotePort = this.getRemotePort();
        Integer other$remotePort = other.getRemotePort();
        if (this$remotePort == null ? other$remotePort != null : !((Object)this$remotePort).equals(other$remotePort)) {
            return false;
        }
        Integer this$localPort = this.getLocalPort();
        Integer other$localPort = other.getLocalPort();
        if (this$localPort == null ? other$localPort != null : !((Object)this$localPort).equals(other$localPort)) {
            return false;
        }
        ServiceProtocolType this$serviceProtocolType = this.getServiceProtocolType();
        ServiceProtocolType other$serviceProtocolType = other.getServiceProtocolType();
        return !(this$serviceProtocolType == null ? other$serviceProtocolType != null : !this$serviceProtocolType.equals(other$serviceProtocolType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractServiceStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $remotePort = this.getRemotePort();
        result = result * 59 + ($remotePort == null ? 43 : ((Object)$remotePort).hashCode());
        Integer $localPort = this.getLocalPort();
        result = result * 59 + ($localPort == null ? 43 : ((Object)$localPort).hashCode());
        ServiceProtocolType $serviceProtocolType = this.getServiceProtocolType();
        result = result * 59 + ($serviceProtocolType == null ? 43 : $serviceProtocolType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractServiceStore(remotePort=" + this.getRemotePort() + ", localPort=" + this.getLocalPort() + ", serviceProtocolType=" + String.valueOf(this.getServiceProtocolType()) + ")";
    }

    @Generated
    public static abstract class AbstractServiceStoreBuilder<C extends AbstractServiceStore, B extends AbstractServiceStoreBuilder<C, B>> {
        @Generated
        private Integer remotePort;
        @Generated
        private Integer localPort;
        @Generated
        private ServiceProtocolType serviceProtocolType;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AbstractServiceStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AbstractServiceStore instance, AbstractServiceStoreBuilder<?, ?> b) {
            b.remotePort(instance.remotePort);
            b.localPort(instance.localPort);
            b.serviceProtocolType(instance.serviceProtocolType);
        }

        @Generated
        public B remotePort(Integer remotePort) {
            this.remotePort = remotePort;
            return this.self();
        }

        @Generated
        public B localPort(Integer localPort) {
            this.localPort = localPort;
            return this.self();
        }

        @Generated
        public B serviceProtocolType(ServiceProtocolType serviceProtocolType) {
            this.serviceProtocolType = serviceProtocolType;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractServiceStore.AbstractServiceStoreBuilder(remotePort=" + this.remotePort + ", localPort=" + this.localPort + ", serviceProtocolType=" + String.valueOf(this.serviceProtocolType) + ")";
        }
    }
}

