/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.host.AbstractHostTransformStore;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import lombok.Generated;

@JsonTypeName(value="customService")
@JsonDeserialize(builder=CustomServiceStoreBuilderImpl.class)
public final class CustomServiceStore
extends AbstractServiceStore
implements AbstractHostTransformStore {
    private final DataStoreEntryRef<HostAddressStore> host;
    private final String address;
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;
    private final Boolean tunnelToLocalhost;

    @Override
    public void checkComplete() throws Throwable {
        super.checkComplete();
        if (this.gateway != null) {
            this.gateway.checkComplete();
        }
    }

    @Override
    public boolean canConvertToAbstractHost() {
        return this.host == null;
    }

    @Override
    public AbstractHostStore createAbstractHostStore() {
        return ((AbstractHostStore.AbstractHostStoreBuilder)((AbstractHostStore.AbstractHostStoreBuilder)AbstractHostStore.builder().host(this.address)).gateway(this.gateway)).build();
    }

    @Override
    public AbstractHostTransformStore withNewParent(DataStoreEntryRef<AbstractHostStore> newParent) {
        return ((CustomServiceStoreBuilder)((CustomServiceStoreBuilder)((CustomServiceStoreBuilder)this.toBuilder().address(null)).gateway(null)).host((DataStoreEntryRef<HostAddressStore>)newParent.asNeeded())).build();
    }

    @Override
    public boolean shouldTunnel() {
        return this.tunnelToLocalhost == null || this.tunnelToLocalhost != false;
    }

    @Generated
    protected CustomServiceStore(CustomServiceStoreBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.address = b.address;
        this.gateway = b.gateway;
        this.tunnelToLocalhost = b.tunnelToLocalhost;
    }

    @Generated
    public static CustomServiceStoreBuilder<?, ?> builder() {
        return new CustomServiceStoreBuilderImpl();
    }

    @Generated
    public CustomServiceStoreBuilder<?, ?> toBuilder() {
        return new CustomServiceStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public DataStoreEntryRef<HostAddressStore> getHost() {
        return this.host;
    }

    @Override
    @Generated
    public String getAddress() {
        return this.address;
    }

    @Override
    @Generated
    public DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return this.gateway;
    }

    @Generated
    public Boolean getTunnelToLocalhost() {
        return this.tunnelToLocalhost;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomServiceStore)) {
            return false;
        }
        CustomServiceStore other = (CustomServiceStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$tunnelToLocalhost = this.getTunnelToLocalhost();
        Boolean other$tunnelToLocalhost = other.getTunnelToLocalhost();
        if (this$tunnelToLocalhost == null ? other$tunnelToLocalhost != null : !((Object)this$tunnelToLocalhost).equals(other$tunnelToLocalhost)) {
            return false;
        }
        DataStoreEntryRef<HostAddressStore> this$host = this.getHost();
        DataStoreEntryRef<HostAddressStore> other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        DataStoreEntryRef<NetworkTunnelStore> this$gateway = this.getGateway();
        DataStoreEntryRef<NetworkTunnelStore> other$gateway = other.getGateway();
        return !(this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomServiceStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $tunnelToLocalhost = this.getTunnelToLocalhost();
        result = result * 59 + ($tunnelToLocalhost == null ? 43 : ((Object)$tunnelToLocalhost).hashCode());
        DataStoreEntryRef<HostAddressStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        DataStoreEntryRef<NetworkTunnelStore> $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CustomServiceStore(super=" + super.toString() + ", host=" + String.valueOf(this.getHost()) + ", address=" + this.getAddress() + ", gateway=" + String.valueOf(this.getGateway()) + ", tunnelToLocalhost=" + this.getTunnelToLocalhost() + ")";
    }

    @Generated
    public static abstract class CustomServiceStoreBuilder<C extends CustomServiceStore, B extends CustomServiceStoreBuilder<C, B>>
    extends AbstractServiceStore.AbstractServiceStoreBuilder<C, B> {
        @Generated
        private DataStoreEntryRef<HostAddressStore> host;
        @Generated
        private String address;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private Boolean tunnelToLocalhost;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CustomServiceStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CustomServiceStore instance, CustomServiceStoreBuilder<?, ?> b) {
            b.host(instance.host);
            b.address(instance.address);
            b.gateway(instance.gateway);
            b.tunnelToLocalhost(instance.tunnelToLocalhost);
        }

        @Generated
        public B host(DataStoreEntryRef<HostAddressStore> host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B address(String address) {
            this.address = address;
            return (B)this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> gateway) {
            this.gateway = gateway;
            return (B)this.self();
        }

        @Generated
        public B tunnelToLocalhost(Boolean tunnelToLocalhost) {
            this.tunnelToLocalhost = tunnelToLocalhost;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CustomServiceStore.CustomServiceStoreBuilder(super=" + super.toString() + ", host=" + String.valueOf(this.host) + ", address=" + this.address + ", gateway=" + String.valueOf(this.gateway) + ", tunnelToLocalhost=" + this.tunnelToLocalhost + ")";
        }
    }

    @JsonTypeName(value="customService")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CustomServiceStoreBuilderImpl
    extends CustomServiceStoreBuilder<CustomServiceStore, CustomServiceStoreBuilderImpl> {
        @Generated
        private CustomServiceStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected CustomServiceStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CustomServiceStore build() {
            return new CustomServiceStore(this);
        }
    }
}

